/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import soc.game.SOCBoard;
import soc.game.SOCPlayingPiece;
import soc.util.IntPair;

public class SOCPlayerNumbers {
    private Vector<Integer>[] numbersForResource;
    private Vector<Integer>[] resourcesForNumber;
    private Hashtable<Integer, Vector<IntPair>> numberAndResourceForHex;
    private int[] landHexCoords;
    public final boolean hasSeaBoard;

    public SOCPlayerNumbers(SOCPlayerNumbers numbers) {
        int i;
        this.hasSeaBoard = numbers.hasSeaBoard;
        this.landHexCoords = numbers.landHexCoords;
        this.numbersForResource = new Vector[6];
        for (i = 1; i <= 5; ++i) {
            this.numbersForResource[i] = new Vector<Integer>(numbers.numbersForResource[i]);
        }
        this.resourcesForNumber = new Vector[13];
        for (i = 0; i < 13; ++i) {
            this.resourcesForNumber[i] = new Vector<Integer>(numbers.resourcesForNumber[i]);
        }
        this.numberAndResourceForHex = new Hashtable((int)((float)numbers.numberAndResourceForHex.size() * 1.4f));
        Enumeration<Integer> hexes = numbers.numberAndResourceForHex.keys();
        while (hexes.hasMoreElements()) {
            Integer hex = hexes.nextElement();
            this.numberAndResourceForHex.put(hex, new Vector(numbers.numberAndResourceForHex.get(hex)));
        }
    }

    public SOCPlayerNumbers(SOCBoard board) throws IllegalArgumentException {
        int i;
        int boardEncodingFormat = board.getBoardEncodingFormat();
        if (boardEncodingFormat < 1 || boardEncodingFormat > 3) {
            throw new IllegalArgumentException("boardEncodingFormat: " + boardEncodingFormat);
        }
        this.hasSeaBoard = boardEncodingFormat == 3;
        this.landHexCoords = board.getLandHexCoords();
        this.numbersForResource = new Vector[6];
        for (i = 1; i <= 5; ++i) {
            this.numbersForResource[i] = new Vector();
        }
        this.resourcesForNumber = new Vector[13];
        for (i = 0; i < 13; ++i) {
            this.resourcesForNumber[i] = new Vector();
        }
        this.numberAndResourceForHex = new Hashtable();
    }

    public void clear() {
        int i;
        for (i = 1; i <= 5; ++i) {
            this.numbersForResource[i].removeAllElements();
        }
        for (i = 0; i < 13; ++i) {
            this.resourcesForNumber[i].removeAllElements();
        }
        this.numberAndResourceForHex.clear();
    }

    public void setLandHexCoordinates(int[] landHex) {
        int L = landHex.length;
        this.landHexCoords = new int[L];
        System.arraycopy(landHex, 0, this.landHexCoords, 0, L);
    }

    public void updateNumbers(SOCPlayingPiece piece, SOCBoard board) {
        this.updateNumbers(piece.getCoordinates(), board);
    }

    public void updateNumbers(int nodeCoord, SOCBoard board) {
        for (int hex : board.getAdjacentHexesToNode(nodeCoord)) {
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            this.addNumberForResource(number, resource, hex);
        }
    }

    public int updateNumbersAndProbability(int nodeCoord, SOCBoard board, int[] numProb, StringBuffer sb) {
        int probTotal = 0;
        for (int hex : board.getAdjacentHexesToNode(nodeCoord)) {
            int number = board.getNumberOnHexFromCoord(hex);
            if (number > 0) {
                int resource = board.getHexTypeFromCoord(hex);
                this.addNumberForResource(number, resource, hex);
                probTotal += numProb[number];
            }
            if (sb == null) continue;
            sb.append(number);
            sb.append(' ');
        }
        return probTotal;
    }

    public Vector<Integer> getResourcesForNumber(int diceNum) {
        return this.resourcesForNumber[diceNum];
    }

    public Vector<Integer> getNumbersForResource(int resource) {
        return this.numbersForResource[resource];
    }

    public Vector<IntPair> getNumberResourcePairsForHex(int hexCoord) {
        return this.numberAndResourceForHex.get(hexCoord);
    }

    public boolean hasNoResourcesForHex(int hexCoord) {
        Vector<IntPair> v = this.numberAndResourceForHex.get(hexCoord);
        if (v == null) {
            return true;
        }
        return v.isEmpty();
    }

    public Vector<Integer> getNumbersForResource(int resource, int robberHex) {
        Vector<Integer> numbers = new Vector<Integer>();
        if (this.landHexCoords == null) {
            return numbers;
        }
        for (int i = 0; i < this.landHexCoords.length; ++i) {
            Vector<IntPair> pairs;
            if (this.landHexCoords[i] == robberHex || (pairs = this.numberAndResourceForHex.get(this.landHexCoords[i])) == null) continue;
            for (IntPair pair : pairs) {
                int res = pair.getB();
                if (res != resource && (!this.hasSeaBoard || res != 7)) continue;
                numbers.addElement(pair.getA());
            }
        }
        return numbers;
    }

    public Vector<Integer> getResourcesForNumber(int diceNum, int robberHex) {
        Vector<Integer> resources = new Vector<Integer>();
        if (this.landHexCoords == null) {
            return resources;
        }
        for (int i = 0; i < this.landHexCoords.length; ++i) {
            Vector<IntPair> pairs;
            if (this.landHexCoords[i] == robberHex || (pairs = this.numberAndResourceForHex.get(this.landHexCoords[i])) == null) continue;
            for (IntPair pair : pairs) {
                if (pair.getA() != diceNum) continue;
                int res = pair.getB();
                if (this.hasSeaBoard && res == 7) {
                    for (int r = 1; r <= 5; ++r) {
                        resources.addElement(r);
                    }
                    continue;
                }
                resources.addElement(res);
            }
        }
        return resources;
    }

    public void addNumberForResource(int diceNum, int resource, int hex) {
        if (resource >= 1 && resource <= 5) {
            this.numbersForResource[resource].addElement(diceNum);
            Integer resourceInt = resource;
            this.resourcesForNumber[diceNum].addElement(resourceInt);
        } else {
            if (!this.hasSeaBoard || resource != 7) {
                return;
            }
            Integer diceNumInt = diceNum;
            for (int res = 1; res <= 5; ++res) {
                this.numbersForResource[res].addElement(diceNumInt);
                this.resourcesForNumber[diceNum].addElement(res);
            }
        }
        Integer hexInt = hex;
        Vector<IntPair> pairs = this.numberAndResourceForHex.get(hexInt);
        if (pairs == null) {
            pairs = new Vector();
            this.numberAndResourceForHex.put(hexInt, pairs);
        }
        pairs.addElement(new IntPair(diceNum, resource));
    }

    public void undoUpdateNumbers(SOCPlayingPiece piece, SOCBoard board) {
        this.undoUpdateNumbers(piece.getCoordinates(), board);
    }

    public void undoUpdateNumbers(int coord, SOCBoard board) {
        for (int hex : board.getAdjacentHexesToNode(coord)) {
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            this.undoAddNumberForResource(number, resource, hex);
        }
    }

    public void undoAddNumberForResource(int number, int resource, int hex) {
        Vector<IntPair> pairs;
        if (resource >= 1 && resource <= 5) {
            for (Integer num : this.numbersForResource[resource]) {
                if (num != number) continue;
                this.numbersForResource[resource].removeElement(num);
                break;
            }
            for (Integer resourceInt : this.resourcesForNumber[number]) {
                if (resourceInt != resource) continue;
                this.resourcesForNumber[number].removeElement(resourceInt);
                break;
            }
        } else {
            if (!this.hasSeaBoard || resource != 7) {
                return;
            }
            block2: for (int res = 1; res <= 5; ++res) {
                Iterator<Integer> numIter = this.numbersForResource[res].iterator();
                while (numIter.hasNext()) {
                    int num = numIter.next();
                    if (num != number) continue;
                    numIter.remove();
                    continue block2;
                }
            }
            boolean[] removed = new boolean[6];
            Iterator<Integer> resIter = this.resourcesForNumber[number].iterator();
            while (resIter.hasNext()) {
                int res = resIter.next();
                if (removed[res]) continue;
                resIter.remove();
                removed[res] = true;
            }
        }
        if ((pairs = this.numberAndResourceForHex.get(hex)) != null) {
            for (IntPair numAndResource : pairs) {
                if (numAndResource.getA() != number || numAndResource.getB() != resource) continue;
                pairs.removeElement(numAndResource);
                break;
            }
        }
    }

    public boolean hasNumber(int number) {
        return !this.resourcesForNumber[number].isEmpty();
    }

    public String toString() {
        String str = "SOCPN:";
        for (int i = 1; i <= 5; ++i) {
            str = str + i + ":";
            for (Integer num : this.numbersForResource[i]) {
                str = str + num + ",";
            }
            str = str + "|";
        }
        return str;
    }
}

