/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.List;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerEvent;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;

public abstract class SOCPlayingPiece
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2300L;
    public static final int ROAD = 0;
    public static final int SETTLEMENT = 1;
    public static final int CITY = 2;
    public static final int SHIP = 3;
    public static final int FORTRESS = 4;
    public static final int VILLAGE = 5;
    public static final int MIN = 0;
    public static final int MAXPLUSONE = 6;
    private static final String[] PIECETYPE_NAMES = new String[]{"ROAD", "SETTLEMENT", "CITY", "SHIP", "FORTRESS", "VILLAGE"};
    protected int pieceType;
    protected transient SOCPlayer player;
    protected int coord;
    protected transient SOCBoard board;
    public int specialVP;
    transient SOCPlayerEvent specialVPEvent;

    protected SOCPlayingPiece(int ptype, SOCPlayer pl, int co, SOCBoard pboard) throws IllegalArgumentException {
        if (pl == null) {
            throw new IllegalArgumentException("player null");
        }
        this.pieceType = ptype;
        this.player = pl;
        this.coord = co;
        if (pboard == null && (pboard = pl.getGame().getBoard()) == null) {
            throw new IllegalArgumentException("player has null board");
        }
        this.board = pboard;
    }

    protected SOCPlayingPiece(int ptype, int co, SOCBoard pboard) throws IllegalArgumentException {
        if (pboard == null) {
            throw new IllegalArgumentException("board null");
        }
        this.pieceType = ptype;
        this.player = null;
        this.coord = co;
        this.board = pboard;
    }

    public List<Integer> getAdjacentEdges() {
        return this.board.getAdjacentEdgesToNode(this.coord);
    }

    public int getType() {
        return this.pieceType;
    }

    public SOCPlayer getPlayer() throws UnsupportedOperationException {
        if (this.player != null) {
            return this.player;
        }
        throw new UnsupportedOperationException("No player for piece type " + this.pieceType + " at 0x" + Integer.toHexString(this.coord));
    }

    public int getPlayerNumber() throws UnsupportedOperationException {
        if (this.player != null) {
            return this.player.getPlayerNumber();
        }
        throw new UnsupportedOperationException("No player for piece type " + this.pieceType + " at 0x" + Integer.toHexString(this.coord));
    }

    public int getCoordinates() {
        return this.coord;
    }

    public void setGameInfo(SOCPlayer pl, SOCBoard b) {
        if (b == null) {
            throw new IllegalArgumentException("board");
        }
        this.player = pl;
        this.board = b;
    }

    public String toString() {
        String clName = this.getClass().getName();
        int dot = clName.lastIndexOf(".");
        if (dot > 0) {
            clName = clName.substring(dot + 1);
        }
        return "SOCPlayingPiece:" + clName + "|type=" + this.pieceType + "|player=" + this.player + "|coord=" + Integer.toHexString(this.coord);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SOCPlayingPiece)) {
            return super.equals(other);
        }
        return this.pieceType == ((SOCPlayingPiece)other).pieceType && this.coord == ((SOCPlayingPiece)other).coord && this.player == ((SOCPlayingPiece)other).player;
    }

    public static SOCResourceSet getResourcesToBuild(int pieceType) throws IllegalArgumentException {
        switch (pieceType) {
            case 0: {
                return SOCRoad.COST;
            }
            case 1: {
                return SOCSettlement.COST;
            }
            case 2: {
                return SOCCity.COST;
            }
            case 3: {
                return SOCShip.COST;
            }
            case -2: 
            case 6: {
                return SOCDevCard.COST;
            }
        }
        throw new IllegalArgumentException("pieceType: " + pieceType);
    }

    public static String getTypeName(int pieceType) throws IllegalArgumentException {
        return SOCPlayingPiece.getTypeName(pieceType, PIECETYPE_NAMES);
    }

    public static String getTypeName(int typeNum, String[] allTypeNames) throws IllegalArgumentException {
        if (typeNum < 0) {
            throw new IllegalArgumentException("typeNum: " + typeNum);
        }
        String name = null;
        if (typeNum < allTypeNames.length) {
            name = allTypeNames[typeNum];
        }
        return name != null ? name : Integer.toString(typeNum);
    }

    public static int getType(String typeName) throws IllegalArgumentException, NumberFormatException {
        return SOCPlayingPiece.getType(typeName, PIECETYPE_NAMES, -1);
    }

    public static int getType(String typeName, String[] allTypeNames, int unknownValue) throws IllegalArgumentException, NumberFormatException {
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("typeName empty or null");
        }
        if (allTypeNames == null) {
            throw new IllegalArgumentException("allTypeNames");
        }
        char c0 = typeName.charAt(0);
        if (c0 >= '0' && c0 <= '9') {
            return Integer.parseInt(typeName);
        }
        if (c0 >= 'A' && c0 <= 'Z') {
            for (int i = 0; i < allTypeNames.length; ++i) {
                if (!typeName.equals(allTypeNames[i])) continue;
                return i;
            }
            return unknownValue;
        }
        throw new IllegalArgumentException("typeName format");
    }
}

