/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.Arrays;
import soc.game.ResourceSet;
import soc.game.SOCResourceConstants;

public class SOCResourceSet
implements ResourceSet,
Serializable,
Cloneable {
    public static final SOCResourceSet EMPTY_SET = new SOCResourceSet();
    private int[] resources = new int[7];

    public SOCResourceSet() {
        this.clear();
    }

    public SOCResourceSet(int cl, int or, int sh, int wh, int wo, int uk) {
        this.resources[1] = cl;
        this.resources[2] = or;
        this.resources[3] = sh;
        this.resources[4] = wh;
        this.resources[5] = wo;
        this.resources[6] = uk;
    }

    public SOCResourceSet(int[] rset) {
        this(rset[0], rset[1], rset[2], rset[3], rset[4], rset.length >= 6 ? rset[5] : 0);
    }

    public SOCResourceSet(ResourceSet other) {
        this();
        this.resources[1] = other.getAmount(1);
        this.resources[2] = other.getAmount(2);
        this.resources[3] = other.getAmount(3);
        this.resources[4] = other.getAmount(4);
        this.resources[5] = other.getAmount(5);
        this.resources[6] = other.getAmount(6);
    }

    public void clear() {
        Arrays.fill(this.resources, 0);
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.resources.length; ++i) {
            if (this.resources[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(int resourceType) {
        if (resourceType >= this.resources.length) {
            return false;
        }
        return this.resources[resourceType] > 0;
    }

    @Override
    public int getAmount(int resourceType) {
        return this.resources[resourceType];
    }

    public int[] getAmounts(boolean withUnknown) {
        int L = withUnknown ? 6 : 5;
        int[] amt = new int[L];
        int i = 0;
        int res = 1;
        while (i < L) {
            amt[i] = this.resources[res];
            ++i;
            ++res;
        }
        return amt;
    }

    @Override
    public int getTotal() {
        int sum = 0;
        for (int i = 1; i < 7; ++i) {
            sum += this.resources[i];
        }
        return sum;
    }

    @Override
    public int getResourceTypeCount() {
        int typ = 0;
        for (int rtype = 1; rtype <= 5; ++rtype) {
            if (this.resources[rtype] == 0) continue;
            ++typ;
        }
        return typ;
    }

    public int getKnownTotal() {
        int sum = 0;
        for (int rtype = 1; rtype <= 5; ++rtype) {
            sum += this.resources[rtype];
        }
        return sum;
    }

    public void setAmount(int amt, int rtype) {
        this.resources[rtype] = amt;
    }

    public void add(int amt, int rtype) {
        int n = rtype;
        this.resources[n] = this.resources[n] + amt;
    }

    public void subtract(int amt, int rtype) {
        this.subtract(amt, rtype, false);
    }

    public void subtract(int amt, int rtype, boolean asUnknown) {
        if (asUnknown && rtype == 6) {
            this.convertToUnknown();
            int n = rtype;
            this.resources[n] = this.resources[n] - amt;
        } else {
            int ourAmt = this.resources[rtype];
            if (amt > ourAmt) {
                this.resources[6] = this.resources[6] - (amt - ourAmt);
                this.resources[rtype] = 0;
            } else {
                int n = rtype;
                this.resources[n] = this.resources[n] - amt;
            }
        }
        if (this.resources[6] < 0) {
            System.err.println("RESOURCE < 0 : RESOURCE TYPE=" + rtype);
        }
    }

    public void add(ResourceSet toAdd) {
        for (int rtype = 1; rtype <= 6; ++rtype) {
            int n = rtype;
            this.resources[n] = this.resources[n] + toAdd.getAmount(rtype);
        }
    }

    public void subtract(ResourceSet toSubtract) {
        this.subtract(toSubtract, false);
    }

    public void subtract(ResourceSet toSubtract, boolean asUnknown) {
        int amountSubtractUnknown = toSubtract.getAmount(6);
        if (asUnknown && amountSubtractUnknown > 0) {
            this.convertToUnknown();
        }
        for (int rtype = 1; rtype <= 5; ++rtype) {
            int n = rtype;
            this.resources[n] = this.resources[n] - toSubtract.getAmount(rtype);
            if (this.resources[rtype] >= 0) continue;
            if (asUnknown) {
                this.resources[6] = this.resources[6] + this.resources[rtype];
            }
            this.resources[rtype] = 0;
        }
        this.resources[6] = this.resources[6] - amountSubtractUnknown;
        if (this.resources[6] < 0 && !asUnknown) {
            this.resources[6] = 0;
        }
    }

    public SOCResourceSet subtract(int subAmount) throws IllegalArgumentException {
        if (subAmount < 0) {
            throw new IllegalArgumentException("< 0");
        }
        int T = this.getTotal();
        if (subAmount > T) {
            throw new IllegalArgumentException("subAmount " + subAmount + " > total " + T);
        }
        SOCResourceSet subbed = new SOCResourceSet();
        int resAmt = this.resources[6];
        if (subAmount > 0 && resAmt > 0) {
            int nSub = subAmount < resAmt ? subAmount : resAmt;
            this.resources[6] = this.resources[6] - nSub;
            subbed.add(nSub, 6);
            subAmount -= nSub;
        }
        for (int rtype = 1; rtype <= 5 && subAmount != 0; ++rtype) {
            resAmt = this.resources[rtype];
            if (resAmt == 0) continue;
            int nSub = subAmount < resAmt ? subAmount : resAmt;
            int n = rtype;
            this.resources[n] = this.resources[n] - nSub;
            subbed.add(nSub, rtype);
            subAmount -= nSub;
        }
        return subbed;
    }

    public void convertToUnknown() {
        int numTotal = this.getTotal();
        this.clear();
        this.resources[6] = numTotal;
    }

    public static boolean gte(ResourceSet a, ResourceSet b) {
        if (b == null) {
            return true;
        }
        return a.getAmount(1) >= b.getAmount(1) && a.getAmount(2) >= b.getAmount(2) && a.getAmount(3) >= b.getAmount(3) && a.getAmount(4) >= b.getAmount(4) && a.getAmount(5) >= b.getAmount(5) && a.getAmount(6) >= b.getAmount(6);
    }

    public static boolean lte(ResourceSet a, ResourceSet b) {
        return a.getAmount(1) <= b.getAmount(1) && a.getAmount(2) <= b.getAmount(2) && a.getAmount(3) <= b.getAmount(3) && a.getAmount(4) <= b.getAmount(4) && a.getAmount(5) <= b.getAmount(5) && a.getAmount(6) <= b.getAmount(6);
    }

    public String toString() {
        String s = "clay=" + this.resources[1] + "|ore=" + this.resources[2] + "|sheep=" + this.resources[3] + "|wheat=" + this.resources[4] + "|wood=" + this.resources[5] + "|unknown=" + this.resources[6];
        return s;
    }

    public String toShortString() {
        String s = "Resources: " + this.resources[1] + " " + this.resources[2] + " " + this.resources[3] + " " + this.resources[4] + " " + this.resources[5] + " " + this.resources[6];
        return s;
    }

    public String toFriendlyString() {
        StringBuffer sb = new StringBuffer();
        if (this.toFriendlyString(sb)) {
            return sb.toString();
        }
        return "nothing";
    }

    public boolean toFriendlyString(StringBuffer sb) {
        boolean needComma = false;
        for (int res = 1; res <= 5; ++res) {
            int amt = this.resources[res];
            if (amt == 0) continue;
            if (needComma) {
                sb.append(", ");
            }
            sb.append(amt);
            sb.append(" ");
            sb.append(SOCResourceConstants.resName(res));
            needComma = true;
        }
        return needComma;
    }

    @Override
    public boolean contains(ResourceSet other) {
        return SOCResourceSet.gte(this, other);
    }

    public boolean contains(int[] other) throws IllegalArgumentException {
        if (other == null) {
            return true;
        }
        if (other.length != 5 && other.length != 6) {
            throw new IllegalArgumentException("other");
        }
        for (int rtype = 1; rtype <= 5; ++rtype) {
            if (this.resources[rtype] >= other[rtype - 1]) continue;
            return false;
        }
        return other.length != 6 || this.resources[6] >= other[5];
    }

    public boolean equals(Object anObject) {
        return anObject instanceof SOCResourceSet && ((SOCResourceSet)anObject).getAmount(1) == this.resources[1] && ((SOCResourceSet)anObject).getAmount(2) == this.resources[2] && ((SOCResourceSet)anObject).getAmount(3) == this.resources[3] && ((SOCResourceSet)anObject).getAmount(4) == this.resources[4] && ((SOCResourceSet)anObject).getAmount(5) == this.resources[5] && ((SOCResourceSet)anObject).getAmount(6) == this.resources[6];
    }

    public int hashCode() {
        return Arrays.hashCode(this.resources);
    }

    public SOCResourceSet copy() {
        SOCResourceSet copy = new SOCResourceSet();
        copy.add(this);
        return copy;
    }

    public void setAmounts(ResourceSet set) {
        if (set instanceof SOCResourceSet) {
            System.arraycopy(((SOCResourceSet)set).resources, 0, this.resources, 0, this.resources.length);
        } else {
            for (int rtype = 1; rtype <= 6; ++rtype) {
                this.resources[rtype] = set.getAmount(rtype);
            }
        }
    }
}

