/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import soc.game.SOCVersionedItem;
import soc.message.SOCMessage;

public class SOCScenario
extends SOCVersionedItem
implements Cloneable,
Comparable<Object> {
    public static final int VERSION_FOR_SCENARIOS = 2000;
    private static final Map<String, SOCScenario> allScenarios = SOCScenario.initAllScenarios();
    public static final int ALL_KNOWN_SCENARIOS_MIN_VERSION = SOCScenario.findAllScenariosGreatestMinVersion();
    public static final String K_SC_NSHO = "SC_NSHO";
    public static final String K_SC_4ISL = "SC_4ISL";
    public static final String K_SC_FOG = "SC_FOG";
    public static final String K_SC_TTD = "SC_TTD";
    public static final String K_SC_CLVI = "SC_CLVI";
    public static final int SC_CLVI_VILLAGES_CLOTH_REMAINING_MIN = 4;
    public static final String K_SC_PIRI = "SC_PIRI";
    public static final String K_SC_FTRI = "SC_FTRI";
    public static final String K_SC_WOND = "SC_WOND";
    public final String scOpts;
    private String scLongDesc;

    private static Map<String, SOCScenario> initAllScenarios() {
        HashMap<String, SOCScenario> allSc = new HashMap<String, SOCScenario>();
        allSc.put(K_SC_NSHO, new SOCScenario(K_SC_NSHO, 2000, 2000, "New Shores", null, "_SC_SEAC=t,SBL=t,VP=t13"));
        allSc.put(K_SC_4ISL, new SOCScenario(K_SC_4ISL, 2000, 2000, "The Four Islands", "Start on one or two islands. Explore and gain SVP by building to others.", "_SC_SEAC=t,SBL=t,VP=t12"));
        allSc.put(K_SC_FOG, new SOCScenario(K_SC_FOG, 2000, 2000, "Fog Islands", "Some hexes are initially hidden by fog. When you build a ship or road to a foggy hex, that hex is revealed. Unless it's water, you are given its resource as a reward.", "_SC_FOG=t,SBL=t,VP=t12"));
        allSc.put(K_SC_TTD, new SOCScenario(K_SC_TTD, 2000, 2000, "Through The Desert", "Start on the main island. Explore and gain SVP by building to the small islands, or through the desert to the coast.", "_SC_SEAC=t,SBL=t,VP=t12"));
        allSc.put(K_SC_CLVI, new SOCScenario(K_SC_CLVI, 2000, 2000, "Cloth Trade with neutral villages", "The small islands' villages give you Cloth; every 2 cloth you have is 1 extra Victory Point. To gain cloth, build ships to a village. You can't move the pirate until you've reached a village. Each player to reach a village gets 1 of its cloth at that time, and 1 more whenever its number is rolled, until the village runs out. Pirate can steal cloth or resources. If fewer than 4 villages still have cloth, the game ends and the player with the most VP wins. (If tied, player with most cloth wins.)", "_SC_CLVI=t,SBL=t,VP=t14,_SC_3IP=t,_SC_0RVP=t"));
        allSc.put(K_SC_PIRI, new SOCScenario(K_SC_PIRI, 2000, 2000, "Pirate Islands and Fortresses", "A pirate fleet patrols, attacking to steal resources from weak players with adjacent settlements/cities until the player builds a strong fleet of Warships. Build ships directly to the Fortress of your color, which the pirates have captured from you. Ship routes can't branch out, only follow dotted lines to the Fortress. Strengthen your fleet by playing Warship development cards to upgrade your ships. When the pirate fleet attacks, you win if you have more Warships than the pirate fleet strength (randomly 1-6). To win the game, you must reach the victory point goal and defeat the Fortress 3 times using warships. No robber or largest army. When 7 is rolled, any pirate fleet attack happens before the usual discards.", "_SC_PIRI=t,SBL=t,VP=t10,_SC_0RVP=t"));
        allSc.put(K_SC_FTRI, new SOCScenario(K_SC_FTRI, 2000, 2000, "The Forgotten Tribe", "Far areas of the board have small habitations of a \"forgotten tribe\" of settlers. When players build ships to reach them, they are greeted with \"gifts\" of a development card, Special Victory Point, or a Port given to the player which must be moved adjacent to one of their coastal settlements/cities if possible, or set aside to place later.", "_SC_FTRI=t,SBL=t,VP=t13"));
        allSc.put(K_SC_WOND, new SOCScenario(K_SC_WOND, 2000, 2000, "Wonders", "Each player chooses a unique Wonder and can build all 4 of its levels. Each Wonder has its own requirements before you may start it, such as several cities built or a port at a certain location. To win you must complete your Wonder's 4 levels, or reach 10 VP and complete more levels than any other player. Has no pirate ship.", "_SC_WOND=t,SBL=t,VP=t10,_SC_SANY=t"));
        return allSc;
    }

    private static final int findAllScenariosGreatestMinVersion() {
        int min = 0;
        for (SOCScenario sc : allScenarios.values()) {
            if (sc.minVersion <= min) continue;
            min = sc.minVersion;
        }
        return min;
    }

    public SOCScenario(String key) throws IllegalArgumentException {
        this(false, key, Integer.MAX_VALUE, 0, "", null, "");
    }

    public SOCScenario(String key, int minVers, int lastModVers, String desc, String longDesc, String opts) throws IllegalArgumentException {
        this(true, key, minVers, lastModVers, desc, longDesc, opts);
    }

    private SOCScenario(boolean isKnown, String key, int minVers, int lastModVers, String desc, String longDesc, String opts) throws IllegalArgumentException {
        super(key, minVers, lastModVers, isKnown, desc);
        if (key.length() > 8) {
            throw new IllegalArgumentException("Key length > 8: " + key);
        }
        if (minVers < 2000 && minVers != -1) {
            throw new IllegalArgumentException("minVers " + minVers + " for key " + key);
        }
        if (lastModVers < 2000 && lastModVers != -1) {
            throw new IllegalArgumentException("lastModVers " + lastModVers + " for key " + key);
        }
        if (longDesc != null) {
            if (!SOCMessage.isSingleLineAndSafe(longDesc, true)) {
                throw new IllegalArgumentException("longDesc fails isSingleLineAndSafe");
            }
            if (longDesc.contains("|")) {
                throw new IllegalArgumentException("longDesc contains |");
            }
        }
        if (opts == null) {
            throw new IllegalArgumentException("opts null");
        }
        if (opts.length() == 0) {
            throw new IllegalArgumentException("opts empty");
        }
        this.scOpts = opts;
        this.scLongDesc = longDesc;
    }

    public static Map<String, SOCScenario> getAllKnownScenarios() {
        return SOCScenario.cloneScenarios(allScenarios);
    }

    public static Set<String> getAllKnownScenarioKeynames() {
        return allScenarios.keySet();
    }

    public static boolean addKnownScenario(SOCScenario scNew) {
        boolean hadOld = null != allScenarios.put(scNew.key, scNew);
        return !hadOld;
    }

    public static void removeUnknownScenario(String scKey) {
        allScenarios.remove(scKey);
    }

    public static Map<String, SOCScenario> cloneScenarios(Map<String, SOCScenario> scens) {
        if (scens == null) {
            return null;
        }
        HashMap<String, SOCScenario> scens2 = new HashMap<String, SOCScenario>();
        for (Map.Entry<String, SOCScenario> e : scens.entrySet()) {
            SOCScenario sc = e.getValue();
            try {
                scens2.put(sc.key, (SOCScenario)sc.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return scens2;
    }

    public static SOCScenario getScenario(String key) {
        return allScenarios.get(key);
    }

    public static String packKnownScenariosToString() {
        return SOCScenario.packScenariosToString(allScenarios);
    }

    public static String packScenariosToString(Map<String, SOCScenario> scMap) {
        return SOCScenario.packScenariosToString(scMap, -2);
    }

    public static String packScenariosToString(Map<String, SOCScenario> scMap, int cliVers) {
        if (scMap == null || scMap.size() == 0) {
            return "-";
        }
        StringBuilder sb = new StringBuilder();
        boolean hadAny = false;
        for (SOCScenario sc : scMap.values()) {
            if (!sc.isKnown || sc.minVersion > cliVers) continue;
            if (hadAny) {
                sb.append(',');
            } else {
                hadAny = true;
            }
            sb.append(sc.key);
        }
        return sb.toString();
    }

    public static Map<String, SOCScenario> parseScenariosToMap(String scstr) {
        if (scstr == null || scstr.equals("-")) {
            return null;
        }
        HashMap<String, SOCScenario> scMap = new HashMap<String, SOCScenario>();
        StringTokenizer st = new StringTokenizer(scstr, ",");
        while (st.hasMoreTokens()) {
            SOCScenario copySc;
            String nvpair = st.nextToken();
            if (allScenarios.containsKey(nvpair)) {
                try {
                    copySc = (SOCScenario)allScenarios.get(nvpair).clone();
                }
                catch (CloneNotSupportedException e) {
                    copySc = new SOCScenario(nvpair);
                }
            } else {
                copySc = new SOCScenario(nvpair);
            }
            scMap.put(copySc.key, copySc);
        }
        return scMap;
    }

    public static StringBuilder adjustScenariosToKnown(Map<String, SOCScenario> newScens, Map<String, SOCScenario> knownScenarios, boolean doServerPreadjust) {
        if (knownScenarios == null) {
            knownScenarios = allScenarios;
        }
        StringBuilder scProblems = new StringBuilder();
        boolean allKnown = true;
        for (Map.Entry<String, SOCScenario> sckv : newScens.entrySet()) {
            SOCScenario sc = sckv.getValue();
            SOCScenario knownSc = knownScenarios.get(sc.key);
            if (knownSc == null) {
                allKnown = false;
                scProblems.append(sc.key);
                scProblems.append(": unknown. ");
                continue;
            }
            if (knownSc.lastModVersion == sc.lastModVersion) continue;
            allKnown = false;
            scProblems.append(sc.key);
            scProblems.append(": lastModVersion mismatch (");
            scProblems.append(knownSc.lastModVersion);
            scProblems.append(" != ");
            scProblems.append(sc.lastModVersion);
            scProblems.append("). ");
        }
        if (allKnown) {
            return null;
        }
        return scProblems;
    }

    public static void addScenario(Map<String, SOCScenario> newScens, String scKey) throws NullPointerException {
        if (newScens.containsKey(scKey)) {
            return;
        }
        try {
            SOCScenario sc = (SOCScenario)allScenarios.get(scKey).clone();
            newScens.put(scKey, sc);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public String getLongDesc() {
        return this.scLongDesc;
    }

    public void setDesc(String desc, String longDesc) throws IllegalArgumentException {
        if (longDesc != null) {
            if (!SOCMessage.isSingleLineAndSafe(longDesc, true)) {
                throw new IllegalArgumentException("longDesc fails isSingleLineAndSafe");
            }
            if (longDesc.contains("|")) {
                throw new IllegalArgumentException("longDesc contains |");
            }
            this.scLongDesc = longDesc;
        }
        this.setDesc(desc);
    }

    public String toString() {
        return this.desc;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof SOCScenario) {
            SOCScenario osc = (SOCScenario)other;
            if (this.key.equals(osc.key)) {
                return 0;
            }
            return this.desc.compareTo(osc.desc);
        }
        return this.hashCode() - other.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SOCScenario) {
            return this.key.equals(((SOCScenario)other).key);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

