/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;

public class SOCSpecialItem
implements Cloneable {
    public static final int SC_WOND_WIN_LEVEL = 4;
    private static final String[] REQ_SC_WOND = new String[]{null, "2C", "S@N2", "C@P,5L", "S@N1", "C,6V", "2C", "S@N2"};
    private static final int[][] COST_SC_WOND = new int[][]{null, {1, 0, 3, 0, 1}, {0, 0, 1, 1, 3}, {0, 2, 0, 3, 0}, {3, 0, 0, 1, 1}, {1, 3, 0, 1, 0}, {1, 0, 3, 0, 1}, {0, 0, 1, 1, 3}};
    private static final String[] SV_SC_WOND = new String[]{null, "w1", "w2", "w3", "w4", "w5", "w1", "w2"};
    protected int gameItemIndex;
    protected SOCPlayer player;
    protected int coord;
    protected int level;
    protected String sv;
    protected SOCResourceSet cost;
    protected int startingCostPiecetype = -1;
    public final List<Requirement> req;

    public static final SOCSpecialItem makeKnownItem(String typeKey, int idx) {
        String req;
        SOCResourceSet costRS;
        if (!typeKey.equals("_SC_WOND")) {
            return new SOCSpecialItem(null, -1, null, null);
        }
        String[] typeReqs = REQ_SC_WOND;
        String[] typeSV = SV_SC_WOND;
        int[][] typeCosts = COST_SC_WOND;
        int itemLevel = 0;
        int startingCostPiecetype = 3;
        if (typeCosts == null || idx < 0 || idx >= typeCosts.length) {
            costRS = null;
        } else {
            int[] cost = typeCosts[idx];
            SOCResourceSet sOCResourceSet = costRS = cost == null ? null : new SOCResourceSet(cost);
        }
        String string = typeReqs != null ? (idx < 0 || idx >= typeReqs.length ? null : typeReqs[idx]) : (req = null);
        String sv = typeSV != null ? (idx < 0 || idx >= typeSV.length ? null : typeSV[idx]) : null;
        SOCSpecialItem si = new SOCSpecialItem(null, -1, itemLevel, sv, costRS, req);
        si.startingCostPiecetype = startingCostPiecetype;
        si.setGameIndex(idx);
        return si;
    }

    public static boolean playerPickItem(String typeKey, SOCGame ga, SOCPlayer pl, int gi, int pi) throws IllegalStateException {
        if (pl.getPlayerNumber() != ga.getCurrentPlayerNumber() || ga.getGameState() != 20 && ga.getGameState() != 100) {
            throw new IllegalStateException();
        }
        if (!"_SC_WOND".equals(typeKey)) {
            throw new IllegalStateException("unknown typeKey: " + typeKey);
        }
        if (gi < 1 || pi != 0) {
            throw new IllegalStateException();
        }
        SOCSpecialItem itm = ga.getSpecialItem(typeKey, gi);
        if (itm == null || itm.player != null && itm.player != pl) {
            throw new IllegalStateException();
        }
        SOCSpecialItem plWonder = pl.getSpecialItem(typeKey, 0);
        if (plWonder != null && plWonder != itm) {
            throw new IllegalStateException();
        }
        SOCResourceSet cost = itm.cost;
        if (cost != null && !pl.getResources().contains(cost)) {
            throw new IllegalStateException("cost");
        }
        if (itm.player == null) {
            if (!itm.checkRequirements(pl, false)) {
                throw new IllegalStateException("requirements");
            }
            int startCostPT = itm.getStartingCostPiecetype();
            if (startCostPT != -1) {
                itm.checkStartingCostPiecetype(pl, true);
                pl.setNumPieces(startCostPT, pl.getNumPieces(startCostPT) - 1);
            }
            itm.setPlayer(pl);
            pl.setSpecialItem(typeKey, 0, itm);
        }
        if (cost != null) {
            pl.getResources().subtract(cost);
        }
        ++itm.level;
        if (itm.level >= 4 || pl.getTotalVP() >= ga.vp_winner) {
            ga.checkForWinner();
        }
        return cost != null;
    }

    public static boolean playerSetItem(String typeKey, SOCGame ga, SOCPlayer pl, int gi, int pi, boolean isSet) throws IllegalStateException {
        throw new IllegalStateException("SET/CLEAR requests not used with this typeKey: " + typeKey);
    }

    public SOCSpecialItem(SOCPlayer pl, int co, SOCResourceSet cost, String req) throws IllegalArgumentException {
        this(pl, co, 0, null, cost, req);
    }

    public SOCSpecialItem(SOCPlayer pl, int co, int lv, String sv, SOCResourceSet cost, String req) throws IllegalArgumentException {
        this.player = pl;
        this.coord = co;
        this.level = lv;
        this.sv = sv;
        this.cost = cost;
        List<Requirement> list = this.req = req != null ? Requirement.parse(req) : null;
        if (sv != null && !SOCMessage.isSingleLineAndSafe(sv)) {
            throw new IllegalArgumentException("sv");
        }
    }

    public int getGameIndex() {
        return this.gameItemIndex;
    }

    public void setGameIndex(int gi) {
        this.gameItemIndex = gi;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(SOCPlayer pl) {
        this.player = pl;
    }

    public int getCoordinates() {
        return this.coord;
    }

    public void setCoordinates(int co) {
        this.coord = co;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int lv) {
        this.level = lv;
    }

    public String getStringValue() {
        return this.sv;
    }

    public void setStringValue(String sv) {
        this.sv = sv;
    }

    public SOCResourceSet getCost() {
        return this.cost;
    }

    public void setCost(SOCResourceSet co) {
        this.cost = co;
    }

    public final boolean checkCost(SOCPlayer pl) {
        return pl != null && (this.cost == null || pl.getResources().contains(this.cost));
    }

    public final int getStartingCostPiecetype() {
        return this.startingCostPiecetype;
    }

    public final boolean checkStartingCostPiecetype(SOCPlayer pl, boolean throwIfUnmet) throws IllegalStateException, ArrayIndexOutOfBoundsException {
        if (this.startingCostPiecetype == -1) {
            return true;
        }
        if (pl.getNumPieces(this.startingCostPiecetype) >= 1) {
            return true;
        }
        if (throwIfUnmet) {
            throw new IllegalStateException("Must pay starting piece type: " + this.startingCostPiecetype);
        }
        return false;
    }

    public final boolean checkRequirements(SOCPlayer pl, boolean checkCost) throws IllegalArgumentException, UnsupportedOperationException {
        if (checkCost && !this.checkCost(pl)) {
            return false;
        }
        return SOCSpecialItem.checkRequirements(pl, this.req);
    }

    public static boolean checkRequirements(SOCPlayer pl, List<Requirement> reqsList) throws IllegalArgumentException, UnsupportedOperationException {
        if (pl == null) {
            return false;
        }
        if (reqsList == null) {
            return true;
        }
        for (Requirement req : reqsList) {
            boolean foundAtNode;
            int count = req.count;
            Vector<SOCPlayingPiece> pieces = null;
            switch (req.reqType) {
                case 'S': {
                    pieces = pl.getSettlements();
                    if (pieces.size() >= count) break;
                    return false;
                }
                case 'C': {
                    pieces = pl.getCities();
                    if (pieces.size() >= count) break;
                    return false;
                }
                case 'V': {
                    if (pl.getTotalVP() >= count) break;
                    return false;
                }
                case 'L': {
                    if (pl.getLongestRoadLength() >= count) break;
                    return false;
                }
                default: {
                    throw new IllegalArgumentException("Unknown requirement type " + req.reqType);
                }
            }
            if (pieces == null) continue;
            if (req.atPort && req.reqType != 'C') {
                throw new UnsupportedOperationException("atPort reqType " + req.reqType + " not implemented");
            }
            if (req.atCoordList != null) {
                foundAtNode = false;
                int[] nodes = ((SOCBoardLarge)pl.getGame().getBoard()).getAddedLayoutPart(req.atCoordList);
                if (nodes == null) {
                    throw new IllegalArgumentException("Requirement uses undefined Added Layout Part " + req.atCoordList);
                }
                for (SOCPlayingPiece pp : pieces) {
                    int node = pp.getCoordinates();
                    for (int i = 0; i < nodes.length; ++i) {
                        if (node != nodes[i]) continue;
                        foundAtNode = true;
                        break;
                    }
                    if (!foundAtNode) continue;
                    break;
                }
                if (foundAtNode) continue;
                return false;
            }
            if (!req.atPort) continue;
            foundAtNode = false;
            SOCBoard board = pl.getGame().getBoard();
            for (SOCPlayingPiece pp : pieces) {
                if (board.getPortTypeFromNodeCoord(pp.getCoordinates()) == -1) continue;
                foundAtNode = true;
                break;
            }
            if (foundAtNode) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SOCSpecialItem:player=" + this.player + "|coord=" + Integer.toHexString(this.coord) + "|level=" + this.level + "|cost=[" + this.cost + "]|req=" + this.req;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SOCSpecialItem)) {
            return false;
        }
        return this.coord == ((SOCSpecialItem)other).coord && this.player == ((SOCSpecialItem)other).player && this.level == ((SOCSpecialItem)other).level;
    }

    public SOCSpecialItem clone() throws CloneNotSupportedException {
        SOCSpecialItem cl = (SOCSpecialItem)super.clone();
        cl.cost = this.cost.copy();
        return cl;
    }

    public static final class Requirement {
        public final char reqType;
        public final int count;
        public final boolean atPort;
        public final String atCoordList;

        public static List<Requirement> parse(String req) throws IllegalArgumentException {
            int L = req.length();
            if (L == 0) {
                return null;
            }
            ArrayList<Requirement> ret = new ArrayList<Requirement>();
            int i = 0;
            while (i < L) {
                int itemCount;
                char c = req.charAt(i);
                if (Character.isDigit(c)) {
                    int j;
                    for (j = i + 1; j < req.length() && Character.isDigit(c = req.charAt(j)); ++j) {
                    }
                    if (j == req.length()) {
                        throw new IllegalArgumentException("Must follow item count with item type in " + req);
                    }
                    itemCount = Integer.parseInt(req.substring(i, j));
                    i = j;
                } else {
                    itemCount = 1;
                }
                char reqType = c;
                if (c < 'A' || c > 'Z') {
                    throw new IllegalArgumentException("Expected item-type letter at position " + i + " in " + req);
                }
                if (++i >= L) {
                    ret.add(new Requirement(reqType, itemCount, false, null));
                    break;
                }
                c = req.charAt(i);
                if (c == ',') {
                    ret.add(new Requirement(reqType, itemCount, false, null));
                    if (++i < L) continue;
                    throw new IllegalArgumentException("ends with ',': " + req);
                }
                if (c != '@') {
                    throw new IllegalArgumentException("Expected @ or , at position " + i + " in " + req);
                }
                if (++i >= L) {
                    throw new IllegalArgumentException("Must follow @ with P or N# in " + req);
                }
                c = req.charAt(i);
                switch (c) {
                    case 'P': {
                        ret.add(new Requirement(reqType, itemCount, true, null));
                        ++i;
                        break;
                    }
                    case 'N': {
                        if (++i < L) {
                            c = req.charAt(i);
                        }
                        if (i < L && Character.isDigit(c)) {
                            ret.add(new Requirement(reqType, itemCount, false, "N" + c));
                            ++i;
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Must follow @ with P or N# in " + req);
                    }
                }
                if (i >= L) continue;
                if (req.charAt(i) != ',') {
                    throw new IllegalArgumentException("Extra characters in spec: Expected , or end of string at position " + i + " in " + req);
                }
                ++i;
            }
            return ret;
        }

        public Requirement(char reqType, int count, boolean atPort, String atCoordList) throws IllegalArgumentException {
            if (atPort) {
                if (reqType != 'C') {
                    throw new IllegalArgumentException("atPort not implemented for reqType " + reqType);
                }
                if (atCoordList != null) {
                    throw new IllegalArgumentException("can't have atPort and atCoordList");
                }
            }
            this.reqType = reqType;
            this.count = count;
            this.atPort = atPort;
            this.atCoordList = atCoordList;
        }

        public final boolean equals(Object other) {
            if (!(other instanceof Requirement)) {
                return false;
            }
            Requirement oth = (Requirement)other;
            return this.reqType == oth.reqType && this.count == oth.count && this.atPort == oth.atPort && (this.atCoordList == null ? oth.atCoordList == null : this.atCoordList.equals(oth.atCoordList));
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.count != 1) {
                sb.append(this.count);
            }
            sb.append(this.reqType);
            if (this.atPort || this.atCoordList != null) {
                sb.append('@');
                if (this.atPort) {
                    sb.append('P');
                } else {
                    sb.append(this.atCoordList);
                }
            }
            return sb.toString();
        }
    }
}

