/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.Arrays;
import soc.game.SOCResourceSet;

public class SOCTradeOffer
implements Serializable,
Cloneable {
    final String game;
    final SOCResourceSet give;
    final SOCResourceSet get;
    final int from;
    final boolean[] to;
    final boolean[] waitingReply;

    public SOCTradeOffer(String game, int from, boolean[] to, SOCResourceSet give, SOCResourceSet get) {
        this.game = game;
        this.from = from;
        this.to = to;
        this.waitingReply = Arrays.copyOf(to, to.length);
        this.give = give;
        this.get = get;
    }

    public SOCTradeOffer(SOCTradeOffer offer) {
        this.game = offer.game;
        this.from = offer.from;
        int maxPlayers = offer.to.length;
        this.to = Arrays.copyOf(offer.to, maxPlayers);
        this.waitingReply = Arrays.copyOf(offer.waitingReply, maxPlayers);
        this.give = offer.give.copy();
        this.get = offer.get.copy();
    }

    public String getGame() {
        return this.game;
    }

    public int getFrom() {
        return this.from;
    }

    public boolean[] getTo() {
        return this.to;
    }

    public boolean[] getWaitingReply() {
        return this.waitingReply;
    }

    public boolean isWaitingReplyFrom(int pn) {
        return pn >= 0 && pn < this.waitingReply.length && this.waitingReply[pn];
    }

    public void clearWaitingReplyFrom(int pn) throws IllegalArgumentException {
        if (pn < 0 || pn >= 6) {
            throw new IllegalArgumentException("pn: " + pn);
        }
        if (pn < this.waitingReply.length) {
            this.waitingReply[pn] = false;
        }
    }

    public SOCResourceSet getGiveSet() {
        return this.give;
    }

    public SOCResourceSet getGetSet() {
        return this.get;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean omitGame) {
        StringBuilder str = new StringBuilder();
        if (!omitGame) {
            str.append("game=" + this.game + '|');
        }
        str.append("from=" + this.from + "|to=" + this.to[0]);
        for (int pn = 1; pn < this.to.length; ++pn) {
            str.append(',');
            str.append(this.to[pn]);
        }
        str.append("|give=" + this.give + "|get=" + this.get);
        return str.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof SOCTradeOffer) {
            SOCTradeOffer offer = (SOCTradeOffer)o;
            for (int i = 0; i < this.to.length; ++i) {
                if (this.to[i] == offer.to[i]) continue;
                return false;
            }
            return this.from == offer.from && this.give.equals(offer.give) && this.get.equals(offer.get);
        }
        return false;
    }

    public int hashCode() {
        return this.give.hashCode() ^ this.get.hashCode() ^ this.from ^ Arrays.hashCode(this.to) ^ Arrays.hashCode(this.waitingReply);
    }
}

