/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soc.game.SOCGameOption;
import soc.message.SOCMessage;

public abstract class SOCVersionedItem
implements Cloneable {
    public static final String REGEX_SORT_RANK_PREFIX_STRING = "^(\\p{Nd}+) -|\\[(\\p{Nd}[^\\]]*)\\]";
    public static final Pattern REGEX_SORT_RANK_PREFIX = Pattern.compile("^(\\p{Nd}+) -|\\[(\\p{Nd}[^\\]]*)\\]");
    public final String key;
    public final int minVersion;
    public final int lastModVersion;
    public final boolean isKnown;
    protected String desc;
    private int sortRank = Integer.MAX_VALUE;

    protected SOCVersionedItem(String key) throws IllegalArgumentException {
        this(key, Integer.MAX_VALUE, Integer.MAX_VALUE, false, key);
    }

    public SOCVersionedItem(String key, int minVers, int lastModVers, boolean isKnown, String desc) throws IllegalArgumentException {
        if (!SOCVersionedItem.isAlphanumericUpcaseAscii(key) && !key.equals("-")) {
            throw new IllegalArgumentException("Key not alphanumeric: " + key);
        }
        if (minVers < 1000 && minVers != -1) {
            throw new IllegalArgumentException("minVers " + minVers + " for key " + key);
        }
        if (lastModVers < 1000 && lastModVers != -1) {
            throw new IllegalArgumentException("lastModVers " + lastModVers + " for key " + key);
        }
        if (!SOCMessage.isSingleLineAndSafe(desc)) {
            throw new IllegalArgumentException("desc fails isSingleLineAndSafe");
        }
        this.key = key;
        this.minVersion = minVers;
        this.lastModVersion = lastModVers;
        this.isKnown = isKnown;
        this.setDesc(desc);
    }

    public final String getDesc() {
        return this.desc;
    }

    public void setDesc(String newDesc) throws IllegalArgumentException {
        if (!SOCMessage.isSingleLineAndSafe(newDesc)) {
            throw new IllegalArgumentException("desc fails isSingleLineAndSafe");
        }
        Matcher m = REGEX_SORT_RANK_PREFIX.matcher(newDesc);
        if (m.find()) {
            String rankValue = m.group(1);
            if (rankValue == null) {
                rankValue = m.group(2);
            }
            int L = newDesc.length();
            int idxAfter = m.end();
            if (idxAfter >= L) {
                throw new IllegalArgumentException("failed to parse rank prefix: nothing after prefix: " + newDesc);
            }
            if (newDesc.charAt(idxAfter) != ' ') {
                throw new IllegalArgumentException("failed to parse rank prefix: trailing space required: " + newDesc);
            }
            try {
                this.sortRank = Integer.parseInt(rankValue);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse rank prefix: " + newDesc, e);
            }
            newDesc = newDesc.substring(idxAfter + 1);
        } else {
            this.sortRank = Integer.MAX_VALUE;
        }
        this.desc = newDesc;
    }

    public int getSortRank() {
        return this.sortRank;
    }

    public int getMinVersion(Map<String, ? extends SOCVersionedItem> items) {
        return this.minVersion;
    }

    public static <I extends SOCVersionedItem> List<String> findUnknowns(Map<String, I> items, Set<String> alreadyKnown) {
        ArrayList<String> unknowns = null;
        for (Map.Entry<String, I> e : items.entrySet()) {
            if (alreadyKnown != null && alreadyKnown.contains(e.getKey())) continue;
            SOCVersionedItem it = (SOCVersionedItem)e.getValue();
            if (it.isKnown) continue;
            if (unknowns == null) {
                unknowns = new ArrayList<String>();
            }
            unknowns.add(it.key);
        }
        return unknowns;
    }

    public static int itemsMinimumVersion(Map<String, ? extends SOCVersionedItem> items) {
        return SOCVersionedItem.itemsMinimumVersion(items, false, null);
    }

    public static int itemsMinimumVersion(Map<String, ? extends SOCVersionedItem> items, boolean calcMinVersionForUnchanged, Map<String, Integer> itemsMins) throws IllegalArgumentException {
        if (items == null) {
            return -1;
        }
        if (itemsMins != null && !itemsMins.isEmpty()) {
            throw new IllegalArgumentException("itemsMins");
        }
        int minVers = -1;
        Map<String, ? extends SOCVersionedItem> itemsChk = calcMinVersionForUnchanged ? items : null;
        for (SOCVersionedItem sOCVersionedItem : items.values()) {
            SOCVersionedItem par;
            String parKey;
            int itmMin = sOCVersionedItem.getMinVersion(itemsChk);
            if (itmMin == -1 || sOCVersionedItem instanceof SOCGameOption && ((SOCGameOption)sOCVersionedItem).hasFlag(32) && (parKey = SOCGameOption.getGroupParentKey(sOCVersionedItem.key)) != null && (!((par = items.get(parKey)) instanceof SOCGameOption) || !((SOCGameOption)par).isSet())) continue;
            if (itmMin > minVers) {
                minVers = itmMin;
            }
            if (itemsMins == null) continue;
            itemsMins.put(sOCVersionedItem.key, itmMin);
        }
        return minVers;
    }

    public static <I extends SOCVersionedItem> List<I> itemsNewerThanVersion(int vers, boolean checkValues, Map<String, I> items) throws IllegalArgumentException {
        return SOCVersionedItem.implItemsVersionCheck(vers, false, checkValues, items);
    }

    public static <I extends SOCVersionedItem> List<I> itemsForVersion(int vers, Map<String, I> items) throws IllegalArgumentException {
        return SOCVersionedItem.implItemsVersionCheck(vers, true, false, items);
    }

    protected static <I extends SOCVersionedItem> List<I> implItemsVersionCheck(int vers, boolean getAllForVersion, boolean checkValues, Map<String, I> items) throws IllegalArgumentException {
        if (getAllForVersion && checkValues) {
            throw new IllegalArgumentException();
        }
        ArrayList<SOCVersionedItem> ret = null;
        for (SOCVersionedItem itm : items.values()) {
            if (getAllForVersion) {
                if (itm.minVersion > vers) {
                    itm = null;
                }
            } else if (checkValues) {
                if (itm.getMinVersion(null) <= vers) {
                    itm = null;
                }
            } else if (itm.lastModVersion <= vers) {
                itm = null;
            }
            if (itm == null) continue;
            if (ret == null) {
                ret = new ArrayList<SOCVersionedItem>();
            }
            ret.add(itm);
        }
        return ret;
    }

    public static final boolean isAlphanumericUpcaseAscii(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_')) {
                return false;
            }
            if (i != 0 || c >= 'A') continue;
            return false;
        }
        return true;
    }
}

