/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.ArrayList;
import java.util.List;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;

public class SOCVillage
extends SOCPlayingPiece {
    private static final long serialVersionUID = 2000L;
    public static final int STARTING_GENERAL_CLOTH = 10;
    public static final int STARTING_CLOTH = 5;
    public final int diceNum;
    private int numCloth;
    private List<SOCPlayer> traders;

    public SOCVillage(int node, SOCBoard board) throws IllegalArgumentException {
        this(node, 0, 5, board);
    }

    public SOCVillage(int node, int dice, int cloth, SOCBoard board) throws IllegalArgumentException {
        super(5, node, board);
        this.diceNum = dice;
        this.numCloth = cloth;
    }

    public int getCloth() {
        return this.numCloth;
    }

    public void setCloth(int numCloth) {
        this.numCloth = numCloth;
    }

    public int takeCloth(int numTake) {
        if (numTake > this.numCloth) {
            numTake = this.numCloth;
            this.numCloth = 0;
        } else {
            this.numCloth -= numTake;
        }
        return numTake;
    }

    public boolean addTradingPlayer(SOCPlayer pl) {
        if (this.traders == null) {
            this.traders = new ArrayList<SOCPlayer>();
        } else if (this.traders.contains(pl)) {
            return false;
        }
        this.traders.add(pl);
        if (this.numCloth > 0 && pl.getGame().isAtServer) {
            --this.numCloth;
            pl.setCloth(1 + pl.getCloth());
            return true;
        }
        return false;
    }

    public void removeTradingPlayer(SOCPlayer pl) {
        if (pl == null || this.traders == null) {
            return;
        }
        this.traders.remove(pl);
    }

    public boolean distributeCloth(SOCGame game, SOCGame.RollResult rollRes) {
        SOCPlayer currPl;
        int nFromGeneral;
        int[] results;
        if (this.numCloth == 0 || this.traders == null || this.traders.isEmpty()) {
            return false;
        }
        if (rollRes.clothVillages == null) {
            rollRes.clothVillages = new ArrayList<SOCVillage>();
        }
        rollRes.clothVillages.add(this);
        if (rollRes.cloth != null) {
            results = rollRes.cloth;
        } else {
            rollRes.cloth = results = new int[1 + game.maxPlayers];
        }
        int n = this.traders.size();
        int nFromHere = this.takeCloth(n);
        if (nFromHere < n) {
            nFromGeneral = ((SOCBoardLarge)this.board).takeCloth(n - nFromHere);
            results[0] = results[0] + nFromGeneral;
        } else {
            nFromGeneral = 0;
        }
        int remain = nFromHere + nFromGeneral;
        int cpn = game.getCurrentPlayerNumber();
        if (cpn != -1 && this.traders.contains(currPl = game.getPlayer(cpn))) {
            currPl.setCloth(1 + currPl.getCloth());
            int n2 = 1 + cpn;
            results[n2] = results[n2] + 1;
            --remain;
        }
        for (int i = 0; i < n && remain > 0; ++i) {
            SOCPlayer pl = this.traders.get(i);
            int pn = pl.getPlayerNumber();
            if (pn == cpn) continue;
            pl.setCloth(1 + pl.getCloth());
            int n3 = 1 + pn;
            results[n3] = results[n3] + 1;
            --remain;
        }
        return true;
    }
}

