/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCAcceptOffer
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    public static final int VERSION_FOR_OMIT_PLAYERELEMENTS = 2500;
    private final String game;
    private int accepting;
    private int offering;
    private final SOCResourceSet resToAccepting;
    private final SOCResourceSet resToOffering;

    public SOCAcceptOffer(String ga, int ac, int of) {
        this(ga, ac, of, null, null);
    }

    public SOCAcceptOffer(String ga, int ac, int of, SOCResourceSet toAc, SOCResourceSet toOf) throws IllegalArgumentException {
        if (toAc == null != (toOf == null)) {
            throw new IllegalArgumentException("toAc, toOf: inconsistent nulls");
        }
        this.messageType = 1039;
        this.game = ga;
        this.accepting = ac;
        this.offering = of;
        this.resToAccepting = toAc;
        this.resToOffering = toOf;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getAcceptingNumber() {
        return this.accepting;
    }

    public int getOfferingNumber() {
        return this.offering;
    }

    public SOCResourceSet getResToAcceptingPlayer() {
        return this.resToAccepting;
    }

    public SOCResourceSet getResToOfferingPlayer() {
        return this.resToOffering;
    }

    @Override
    public String toCmd() {
        StringBuffer cmd = new StringBuffer("1039|" + this.game + "," + this.accepting + "," + this.offering);
        if (this.resToAccepting != null) {
            int i;
            for (i = 1; i <= 5; ++i) {
                cmd.append(",").append(this.resToAccepting.getAmount(i));
            }
            for (i = 1; i <= 5; ++i) {
                cmd.append(",").append(this.resToOffering.getAmount(i));
            }
        }
        return cmd.toString();
    }

    public static SOCAcceptOffer parseDataStr(String s) {
        int of;
        int ac;
        String ga;
        SOCResourceSet toAc = null;
        SOCResourceSet toOf = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            ac = Integer.parseInt(st.nextToken());
            of = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                int i;
                toAc = new SOCResourceSet();
                toOf = new SOCResourceSet();
                for (i = 1; i <= 5; ++i) {
                    toAc.setAmount(Integer.parseInt(st.nextToken()), i);
                }
                for (i = 1; i <= 5; ++i) {
                    toOf.setAmount(Integer.parseInt(st.nextToken()), i);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCAcceptOffer(ga, ac, of, toAc, toOf);
    }

    public static String stripAttribNames(String message) {
        message = message.replace("toAccepting=", "").replace("toOffering=", "").replaceAll("\\|unknown=0", "");
        return SOCMessage.stripAttribNames(message);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("SOCAcceptOffer:game=" + this.game + "|accepting=" + this.accepting + "|offering=" + this.offering);
        if (this.resToAccepting != null) {
            sb.append("|toAccepting=").append(this.resToAccepting).append("|toOffering=").append(this.resToOffering);
        }
        return sb.toString();
    }
}

