/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;

public class SOCAuthRequest
extends SOCMessage
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2000L;
    public static final int VERSION_FOR_AUTHREQUEST = 1119;
    public static final String ROLE_GAME_PLAYER = "P";
    public static final String ROLE_USER_ADMIN = "UA";
    public static final int SCHEME_CLIENT_PLAINTEXT = 1;
    public static final int PASSWORD_LEN_MAX = 256;
    public final String role;
    public final String nickname;
    public final String password;
    public final int authScheme;
    public final String host;

    public SOCAuthRequest(String ro, String nn, String pw, int sch, String hn) throws IllegalArgumentException {
        if (!SOCMessage.isSingleLineAndSafe(ro)) {
            throw new IllegalArgumentException("role: " + ro);
        }
        if (!SOCMessage.isSingleLineAndSafe(nn)) {
            throw new IllegalArgumentException("nickname: " + nn);
        }
        if (hn != null && !SOCMessage.isSingleLineAndSafe(hn)) {
            throw new IllegalArgumentException("hostname: " + hn);
        }
        this.messageType = 999;
        this.role = ro;
        this.nickname = nn;
        this.authScheme = sch;
        this.host = hn != null && hn.length() > 0 ? hn : null;
        this.password = pw;
    }

    @Override
    public String toCmd() {
        return "999|" + this.role + "," + this.nickname + "," + this.authScheme + "," + (this.host != null && this.host.length() > 0 ? this.host : "\t") + "," + this.password;
    }

    public static SOCAuthRequest parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String pw;
            String ro = st.nextToken();
            String nn = st.nextToken();
            int sch = Integer.parseInt(st.nextToken());
            String hn = st.nextToken();
            if (hn.equals("\t")) {
                hn = null;
            }
            if ((pw = st.nextToken(Character.toString('\u0001')).trim()).startsWith(",")) {
                pw = pw.substring(1);
            }
            return new SOCAuthRequest(ro, nn, pw, sch, hn);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public final int getMinimumVersion() {
        return 1119;
    }

    @Override
    public final String toString() {
        return "SOCAuthRequest:role=" + this.role + "|nickname=" + this.nickname + "|scheme=" + this.authScheme + (this.host != null ? "|host=" + this.host : "") + (this.password != null && this.password.length() > 0 ? "|password=***" : "|password empty");
    }
}

