/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCBankTrade
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int VERSION_FOR_OMIT_PLAYERELEMENTS = 2500;
    private String game;
    private SOCResourceSet give;
    private SOCResourceSet get;
    private final int playerNumber;

    public SOCBankTrade(String ga, SOCResourceSet give, SOCResourceSet get, int pn) {
        this.messageType = 1040;
        this.game = ga;
        this.give = give;
        this.get = get;
        this.playerNumber = pn;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCResourceSet getGiveSet() {
        return this.give;
    }

    public SOCResourceSet getGetSet() {
        return this.get;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    @Override
    public String toCmd() {
        int i;
        StringBuilder cmd = new StringBuilder("1040|" + this.game);
        for (i = 1; i <= 5; ++i) {
            cmd.append(",");
            cmd.append(this.give.getAmount(i));
        }
        for (i = 1; i <= 5; ++i) {
            cmd.append(",");
            cmd.append(this.get.getAmount(i));
        }
        if (this.playerNumber != -1) {
            cmd.append(",");
            cmd.append(this.playerNumber);
        }
        return cmd.toString();
    }

    public static SOCBankTrade parseDataStr(String s) {
        String ga;
        int pn = -1;
        SOCResourceSet give = new SOCResourceSet();
        SOCResourceSet get = new SOCResourceSet();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            int i;
            ga = st.nextToken();
            for (i = 1; i <= 5; ++i) {
                give.setAmount(Integer.parseInt(st.nextToken()), i);
            }
            for (i = 1; i <= 5; ++i) {
                get.setAmount(Integer.parseInt(st.nextToken()), i);
            }
            if (st.hasMoreTokens()) {
                pn = Integer.parseInt(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCBankTrade(ga, give, get, pn);
    }

    public static String stripAttribNames(String message) {
        message = message.replace("give=", "");
        message = message.replace("get=", "");
        message = message.replaceAll("\\|unknown=0", "");
        return SOCMessage.stripAttribNames(message);
    }

    @Override
    public String toString() {
        return "SOCBankTrade:game=" + this.game + "|give=" + this.give + "|get=" + this.get + (this.playerNumber != -1 ? "|pn=" + this.playerNumber : "");
    }
}

