/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.util.DataUtils;

public class SOCBoardLayout
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int VERSION_FOR_OMIT_IF_EMPTY_NEW_GAME = 2000;
    private static final int[] boardNum2sentNum = new int[]{-1, -1, 0, 1, 2, 3, 4, -1, 5, 6, 7, 8, 9};
    private static final int[] sentNum2BoardNum = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 11, 12};
    private static final int SENTLAND_WATER = 6;
    private static final int SENTLAND_DESERT = 0;
    private String game;
    private int[] hexLayout;
    private int[] numberLayout;
    private int robberHex;

    public SOCBoardLayout(String ga, int[] hl, int[] nl, int rh) {
        this(ga, hl, nl, rh, false);
    }

    public SOCBoardLayout(String ga, int[] hl, int[] nl, int rh, boolean alreadyMapped) {
        this.messageType = 1014;
        this.game = ga;
        if (alreadyMapped) {
            this.hexLayout = hl;
            this.numberLayout = nl;
        } else {
            int i;
            this.hexLayout = new int[hl.length];
            for (i = hl.length - 1; i >= 0; --i) {
                int h = hl[i];
                switch (h) {
                    case 0: {
                        h = 6;
                        break;
                    }
                    case 6: {
                        h = 0;
                        break;
                    }
                }
                this.hexLayout[i] = h;
            }
            this.numberLayout = new int[nl.length];
            for (i = nl.length - 1; i >= 0; --i) {
                int n = nl[i];
                if (n != -1) {
                    n = boardNum2sentNum[n];
                }
                this.numberLayout[i] = n;
            }
        }
        this.robberHex = rh;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int[] getHexLayout() {
        int[] hl = new int[this.hexLayout.length];
        for (int i = hl.length - 1; i >= 0; --i) {
            int h = this.hexLayout[i];
            switch (h) {
                case 6: {
                    h = 0;
                    break;
                }
                case 0: {
                    h = 6;
                    break;
                }
            }
            hl[i] = h;
        }
        return hl;
    }

    public int[] getNumberLayout() {
        int[] nl = new int[this.numberLayout.length];
        for (int i = nl.length - 1; i >= 0; --i) {
            int n = this.numberLayout[i];
            n = n != -1 ? sentNum2BoardNum[n] : 0;
            nl[i] = n;
        }
        return nl;
    }

    public int getRobberHex() {
        return this.robberHex;
    }

    @Override
    public String toCmd() {
        int i;
        StringBuilder cmd = new StringBuilder("1014|" + this.game);
        for (i = 0; i < 37; ++i) {
            cmd.append(',').append(this.hexLayout[i]);
        }
        for (i = 0; i < 37; ++i) {
            cmd.append(',').append(this.numberLayout[i]);
        }
        cmd.append(',').append(this.robberHex);
        return cmd.toString();
    }

    public static SOCBoardLayout parseDataStr(String s) {
        int rh;
        String ga;
        int[] hl = new int[37];
        int[] nl = new int[37];
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            int i;
            ga = st.nextToken();
            for (i = 0; i < 37; ++i) {
                hl[i] = Integer.parseInt(st.nextToken());
            }
            for (i = 0; i < 37; ++i) {
                nl[i] = Integer.parseInt(st.nextToken());
            }
            rh = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCBoardLayout(ga, hl, nl, rh, true);
    }

    public static String stripAttribNames(String messageStrParams) {
        String sp = SOCMessage.stripAttribNames(messageStrParams);
        if (sp == null) {
            return null;
        }
        String[] pieces = sp.split(",");
        StringBuffer ret = new StringBuffer();
        ret.append(pieces[0]);
        ret.append(",");
        for (int i = 0; i < 2; ++i) {
            String s = pieces[i + 1];
            s = s.substring(2, s.length() - 1);
            ret.append(s.replace(' ', ','));
        }
        int robber = Integer.parseUnsignedInt(pieces[3].substring(2), 16);
        ret.append(robber);
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCBoardLayout:game=");
        sb.append(this.game);
        sb.append("|hexLayout=");
        DataUtils.arrayIntoStringBuilder(this.hexLayout, sb, false);
        sb.append("|numberLayout=");
        DataUtils.arrayIntoStringBuilder(this.numberLayout, sb, false);
        sb.append("|robberHex=0x");
        sb.append(Integer.toHexString(this.robberHex));
        return sb.toString();
    }
}

