/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.util.DataUtils;

public class SOCBoardLayout2
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2300L;
    private static final String[] KNOWN_KEYS = new String[]{"HL", "NL", "RH", "PL", "LH", "PH", "PX", "RX", "CV"};
    public static final int VERSION_FOR_BOARDLAYOUT2 = 1108;
    private static final int SENTLAND_WATER = 6;
    private static final int SENTLAND_DESERT = 0;
    private final String game;
    private final int boardEncodingFormat;
    private Map<String, Object> layoutParts;

    public SOCBoardLayout2(String ga, int bef, Map<String, Object> parts) {
        this.messageType = 1084;
        this.game = ga;
        this.boardEncodingFormat = bef;
        this.layoutParts = parts;
    }

    public SOCBoardLayout2(String ga, int bef, int[] hl, int[] nl, int[] pl, int rh) {
        this.messageType = 1084;
        this.game = ga;
        this.boardEncodingFormat = bef;
        this.layoutParts = new HashMap<String, Object>();
        int[] hexLayout = new int[hl.length];
        for (int i = hl.length - 1; i >= 0; --i) {
            int h = hl[i];
            switch (h) {
                case 0: {
                    h = 6;
                    break;
                }
                case 6: {
                    h = 0;
                    break;
                }
            }
            hexLayout[i] = h;
        }
        this.layoutParts.put("HL", hexLayout);
        this.layoutParts.put("NL", nl);
        if (pl != null) {
            this.layoutParts.put("PL", pl);
        }
        this.layoutParts.put("RH", rh);
    }

    public SOCBoardLayout2(String ga, int bef, int[] lh, int[] pl, int rh, int ph, int[] px, int[] rx, Map<String, int[]> other) {
        this.messageType = 1084;
        this.game = ga;
        this.boardEncodingFormat = bef;
        this.layoutParts = new HashMap<String, Object>();
        if (lh != null) {
            this.layoutParts.put("LH", lh);
        }
        if (pl != null) {
            this.layoutParts.put("PL", pl);
        }
        if (rh > 0) {
            this.layoutParts.put("RH", rh);
        }
        if (ph > 0) {
            this.layoutParts.put("PH", ph);
        }
        if (px != null) {
            this.layoutParts.put("PX", px);
        }
        if (rx != null) {
            this.layoutParts.put("RX", rx);
        }
        if (other != null) {
            this.layoutParts.putAll(other);
        }
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getBoardEncodingFormat() {
        return this.boardEncodingFormat;
    }

    public int[] getIntArrayPart(String pkey) {
        int i;
        int[] iap;
        Object part = this.layoutParts.get(pkey);
        if (part instanceof ArrayList) {
            int L = ((ArrayList)part).size();
            iap = new int[L];
            for (i = 0; i < L; ++i) {
                iap[i] = ((Number)((ArrayList)part).get(i)).intValue();
            }
        } else {
            iap = (int[])part;
        }
        if (!pkey.equals("HL")) {
            return iap;
        }
        int[] hl = new int[iap.length];
        for (i = hl.length - 1; i >= 0; --i) {
            int h = iap[i];
            switch (h) {
                case 6: {
                    h = 0;
                    break;
                }
                case 0: {
                    h = 6;
                    break;
                }
            }
            hl[i] = h;
        }
        return hl;
    }

    public int getIntPart(String pkey) {
        Object obj = this.layoutParts.get(pkey);
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String sobj = (String)obj;
        if (sobj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(sobj);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getStringPart(String pkey) {
        return (String)this.layoutParts.get(pkey);
    }

    public HashMap<String, int[]> getAddedParts() {
        HashMap<String, int[]> added = null;
        for (String key : this.layoutParts.keySet()) {
            boolean known = false;
            for (String knk : KNOWN_KEYS) {
                if (!key.equals(knk)) continue;
                known = true;
                break;
            }
            if (known) continue;
            if (added == null) {
                added = new HashMap<String, int[]>();
            }
            added.put(key, this.getIntArrayPart(key));
        }
        return added;
    }

    @Override
    public String toCmd() {
        StringBuilder cmd = new StringBuilder();
        cmd.append(1084);
        cmd.append("|").append(this.game);
        cmd.append(',').append(this.boardEncodingFormat);
        for (String okey : this.layoutParts.keySet()) {
            cmd.append(',');
            cmd.append(okey);
            cmd.append(',');
            Object ov = this.layoutParts.get(okey);
            if (ov instanceof Integer) {
                cmd.append(Integer.toString((Integer)ov));
                continue;
            }
            if (ov instanceof int[]) {
                int[] ovi = (int[])ov;
                cmd.append("[");
                cmd.append(Integer.toString(ovi.length));
                for (int i = 0; i < ovi.length; ++i) {
                    cmd.append(',');
                    cmd.append(Integer.toString(ovi[i]));
                }
                continue;
            }
            cmd.append(ov.toString());
        }
        return cmd.toString();
    }

    public static SOCBoardLayout2 parseDataStr(String s) {
        int bef;
        String ga;
        HashMap<String, Object> parts = new HashMap<String, Object>();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            bef = Integer.parseInt(st.nextToken());
            while (st.hasMoreTokens()) {
                String pname = st.nextToken();
                String pvalue = st.nextToken();
                if (pvalue.startsWith("[")) {
                    int n = Integer.parseInt(pvalue.substring(1));
                    int[] pv = new int[n];
                    for (int i = 0; i < n; ++i) {
                        pv[i] = Integer.parseInt(st.nextToken());
                    }
                    parts.put(pname, pv);
                    continue;
                }
                parts.put(pname, Integer.parseInt(pvalue));
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCBoardLayout2(ga, bef, parts);
    }

    public static String stripAttribNames(String messageStrParams) {
        String[] pieces = messageStrParams.split("\\|");
        StringBuffer ret = new StringBuffer();
        if (!pieces[0].startsWith("game=")) {
            return null;
        }
        ret.append(pieces[0].substring(5)).append(',');
        if (!pieces[1].startsWith("bef=")) {
            return null;
        }
        ret.append(pieces[1].substring(4)).append(',');
        for (int i = 2; i < pieces.length; ++i) {
            String kv = pieces[i];
            int idx = kv.indexOf(61);
            if (idx <= 0) {
                return null;
            }
            String k = kv.substring(0, idx);
            String v = kv.substring(idx + 1);
            if (v.isEmpty()) {
                return null;
            }
            ret.append(k).append(',');
            if (v.startsWith("{ ")) {
                if (!v.endsWith(" }")) {
                    return null;
                }
                boolean notHex = k.equals("HL") || k.equals("NL");
                String[] vals = v.substring(2, v.length() - 2).split(" ");
                ret.append('[').append(vals.length).append(',');
                for (String vitem : vals) {
                    if (notHex) {
                        ret.append(vitem);
                    } else {
                        try {
                            ret.append(Integer.parseInt(vitem, 16));
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                    ret.append(',');
                }
                continue;
            }
            ret.append(v).append(',');
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCBoardLayout2:game=");
        sb.append(this.game);
        sb.append("|bef=");
        sb.append(this.boardEncodingFormat);
        for (String okey : this.layoutParts.keySet()) {
            sb.append("|");
            sb.append(okey);
            sb.append("=");
            Object kv = this.layoutParts.get(okey);
            if (kv instanceof int[]) {
                DataUtils.arrayIntoStringBuilder((int[])kv, sb, !okey.equals("HL") && !okey.equals("NL"));
                continue;
            }
            sb.append(kv.toString());
        }
        return sb.toString();
    }
}

