/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.List;
import soc.message.SOCMessageForGame;
import soc.message.SOCMessageTemplateMi;

public class SOCBotGameDataCheck
extends SOCMessageTemplateMi
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    public static final int MIN_VERSION = 2500;
    public static final int TYPE_RESOURCE_AMOUNTS = 1;
    private final int dataType;
    private final int[] values;

    public SOCBotGameDataCheck(String ga, int dtype, int[] values) throws NullPointerException {
        super(1103, ga, new int[1 + values.length]);
        int L = values.length;
        if (L == 0) {
            throw new NullPointerException("length 0");
        }
        this.dataType = dtype;
        this.values = values;
        this.pa[0] = dtype;
        System.arraycopy(values, 0, this.pa, 1, L);
    }

    @Override
    public final int getMinimumVersion() {
        return 2500;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int[] getValues() {
        return this.values;
    }

    public static SOCBotGameDataCheck parseDataStr(List<String> pa) {
        if (pa == null) {
            return null;
        }
        int L = pa.size();
        if (L < 3) {
            return null;
        }
        try {
            String gaName = pa.get(0);
            int dataType = Integer.parseInt(pa.get(1));
            int[] values = new int[L - 2];
            for (int i = 2; i < L; ++i) {
                values[i - 2] = Integer.parseInt(pa.get(i));
            }
            return new SOCBotGameDataCheck(gaName, dataType, values);
        }
        catch (Exception e) {
            return null;
        }
    }
}

