/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Map;
import java.util.StringTokenizer;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCBotJoinGameRequest
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    private String game;
    private int playerNumber;
    private String optsStr;
    private Map<String, SOCGameOption> opts = null;

    public SOCBotJoinGameRequest(String ga, int pn, SOCGameOptionSet opts) {
        this.messageType = 1023;
        this.game = ga;
        this.playerNumber = pn;
        Map<String, SOCGameOption> optsMap = opts != null ? opts.getAll() : null;
        this.opts = optsMap;
        this.optsStr = SOCGameOption.packOptionsToString(optsMap, false, false);
    }

    public SOCBotJoinGameRequest(String ga, int pn, String optsStr) {
        this.messageType = 1023;
        this.game = ga;
        this.playerNumber = pn;
        this.opts = null;
        this.optsStr = optsStr;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public Map<String, SOCGameOption> getOptions(SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        if (this.opts == null) {
            this.opts = SOCGameOption.parseOptionsToMap(this.optsStr, knownOpts);
        }
        return this.opts;
    }

    @Override
    public String toCmd() {
        return "1023|" + this.game + "," + this.playerNumber + "," + this.optsStr;
    }

    public static SOCBotJoinGameRequest parseDataStr(String s) {
        String optstr;
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            optstr = st.nextToken("|");
            if (!optstr.isEmpty() && optstr.charAt(0) == ',') {
                optstr = optstr.substring(1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCBotJoinGameRequest(ga, pn, optstr);
    }

    @Override
    public String toString() {
        String s = "SOCBotJoinGameRequest:game=" + this.game + "|playerNumber=" + this.playerNumber + "|opts=" + this.optsStr;
        return s;
    }
}

