/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCBuildRequest
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int pieceType;

    public SOCBuildRequest(String ga, int pt) throws IllegalArgumentException {
        if (pt < -1) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        this.messageType = 1043;
        this.game = ga;
        this.pieceType = pt;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPieceType() {
        return this.pieceType;
    }

    @Override
    public String toCmd() {
        return "1043|" + this.game + "," + this.pieceType;
    }

    public static SOCBuildRequest parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String ga = st.nextToken();
            int pt = Integer.parseInt(st.nextToken());
            return new SOCBuildRequest(ga, pt);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "SOCBuildRequest:game=" + this.game + "|pieceType=" + this.pieceType;
    }
}

