/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.message.SOCGameMembers;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;

public class SOCChannelMembers
extends SOCMessage {
    private static final long serialVersionUID = 2000L;
    private List<String> members;
    private String channel;

    public SOCChannelMembers(String ch, List<?> ml) {
        this(ch, new ArrayList<String>(), false);
        try {
            for (Object obj : ml) {
                if (obj instanceof Connection) {
                    this.members.add(((Connection)obj).getData());
                    continue;
                }
                if (obj instanceof String) {
                    this.members.add((String)obj);
                    continue;
                }
                this.members.add(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SOCChannelMembers(String ch, List<String> ml, boolean clientMarker) {
        this.messageType = 1002;
        this.members = ml;
        this.channel = ch;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        StringBuilder cmd = new StringBuilder("1002|" + this.channel);
        try {
            for (String mname : this.members) {
                cmd.append(',').append(mname);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd.toString();
    }

    public static SOCChannelMembers parseDataStr(String s) {
        String ch;
        ArrayList<String> ml = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ch = st.nextToken();
            while (st.hasMoreTokens()) {
                ml.add(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCChannelMembers(ch, ml, true);
    }

    public static String stripAttribNames(String messageStrParams) {
        return SOCGameMembers.stripAttribNamesToMemberList("channel=", messageStrParams);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("SOCChannelMembers:channel=");
        sb.append(this.channel);
        sb.append("|members=");
        if (this.members != null) {
            sb.append(this.members);
        }
        return sb.toString();
    }
}

