/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCGameTextMsg;
import soc.message.SOCMessage;

public class SOCChannelTextMsg
extends SOCMessage {
    private static final long serialVersionUID = 100L;
    private static String sep2_alt = "\u0000";
    private String channel;
    private String nickname;
    private String text;

    public SOCChannelTextMsg(String ch, String nn, String tm) {
        this.messageType = 1005;
        this.channel = ch;
        this.nickname = nn;
        this.text = tm;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String toCmd() {
        return "1005|" + this.channel + sep2_alt + this.nickname + sep2_alt + this.text;
    }

    public static SOCChannelTextMsg parseDataStr(String s) {
        String tm;
        String nn;
        String ch;
        StringTokenizer st = new StringTokenizer(s, sep2_alt);
        try {
            ch = st.nextToken();
            nn = st.nextToken();
            tm = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCChannelTextMsg(ch, nn, tm);
    }

    public static String stripAttribNames(String messageStrParams) {
        return SOCGameTextMsg.stripAttribNamesToTextMsg("channel=", messageStrParams);
    }

    @Override
    public String toString() {
        String s = "SOCChannelTextMsg:channel=" + this.channel + "|nickname=" + this.nickname + "|text=" + this.text;
        return s;
    }
}

