/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.util.DataUtils;

public class SOCChannels
extends SOCMessage {
    private static final long serialVersionUID = 2000L;
    private final List<String> channels;

    public SOCChannels(List<String> cl) {
        this.messageType = 1003;
        this.channels = cl;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    public String toCmd() {
        StringBuilder cmd = new StringBuilder("1003|");
        boolean any = false;
        for (String chan : this.channels) {
            if (any) {
                cmd.append(",");
            } else {
                any = true;
            }
            cmd.append(chan);
        }
        return cmd.toString();
    }

    public static SOCChannels parseDataStr(String s) {
        ArrayList<String> cl = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            while (st.hasMoreTokens()) {
                cl.add(st.nextToken());
            }
        }
        catch (Exception e) {
            System.err.println("SOCChannels parseDataStr ERROR - " + e);
            return null;
        }
        return new SOCChannels(cl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCChannels:channels=");
        if (this.channels != null) {
            DataUtils.listIntoStringBuilder(this.channels, sb);
        }
        return sb.toString();
    }
}

