/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Arrays;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCChoosePlayerRequest
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    private final String game;
    private final boolean allowChooseNone;
    private final boolean[] choices;

    public SOCChoosePlayerRequest(String ga, boolean[] ch, boolean canChooseNone) {
        this.messageType = 1036;
        this.game = ga;
        this.choices = ch;
        this.allowChooseNone = canChooseNone;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public boolean[] getChoices() {
        return this.choices;
    }

    public boolean canChooseNone() {
        return this.allowChooseNone;
    }

    @Override
    public String toCmd() {
        return SOCChoosePlayerRequest.toCmd(this.game, this.choices, this.allowChooseNone);
    }

    public static String toCmd(String ga, boolean[] ch, boolean canChooseNone) {
        StringBuilder mes = new StringBuilder("1036|" + ga);
        if (canChooseNone) {
            mes.append(",NONE");
        }
        for (int i = 0; i < ch.length; ++i) {
            mes.append(',');
            mes.append(ch[i] ? "true" : "false");
        }
        return mes.toString();
    }

    public static SOCChoosePlayerRequest parseDataStr(String s) {
        boolean[] ch;
        String ga;
        boolean canChooseNone = false;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            int n = st.countTokens();
            if (n == 0) {
                return null;
            }
            String tok = st.nextToken();
            if (tok.equals("NONE")) {
                canChooseNone = true;
                if (--n == 0) {
                    return null;
                }
                tok = st.nextToken();
            }
            ch = new boolean[n];
            int count = 0;
            while (true) {
                ch[count] = tok.equals("true");
                if (st.hasMoreTokens()) {
                    tok = st.nextToken();
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCChoosePlayerRequest(ga, ch, canChooseNone);
    }

    public static String stripAttribNames(String messageStrParams) {
        String[] pieces = messageStrParams.split("\\|");
        if (pieces.length < 2) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        if (!pieces[0].startsWith("game=")) {
            return null;
        }
        ret.append(pieces[0].substring(5));
        int i = 1;
        if (pieces[1].startsWith("canChooseNone=")) {
            ++i;
            if (!pieces[1].equals("canChooseNone=true")) {
                return null;
            }
            ret.append(",NONE");
        }
        String s = pieces[i];
        int L = s.length();
        if (s.charAt(8) != '[' || s.charAt(L - 1) != ']') {
            return null;
        }
        for (String piece : s.substring(9, L - 1).split(", ")) {
            ret.append(',').append(piece);
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCChoosePlayerRequest:game=" + this.game);
        if (this.canChooseNone()) {
            sb.append("|canChooseNone=true");
        }
        sb.append("|choices=" + Arrays.toString(this.choices));
        return sb.toString();
    }
}

