/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCClearTradeMsg
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1112L;
    public static final int VERSION_FOR_CLEAR_ALL = 1112;
    private String game;
    private int playerNumber;

    public SOCClearTradeMsg(String ga, int pn) {
        this.messageType = 1042;
        this.game = ga;
        this.playerNumber = pn;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    @Override
    public String toCmd() {
        return SOCClearTradeMsg.toCmd(this.game, this.playerNumber);
    }

    public static String toCmd(String ga, int pn) {
        return "1042|" + ga + "," + pn;
    }

    public static SOCClearTradeMsg parseDataStr(String s) {
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCClearTradeMsg(ga, pn);
    }

    @Override
    public String toString() {
        return "SOCClearTradeMsg:game=" + this.game + "|playerNumber=" + this.playerNumber;
    }
}

