/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;

public class SOCCreateAccount
extends SOCMessage
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2000L;
    private String nickname;
    private String password;
    private String host;
    private String email;

    public SOCCreateAccount(String nn, String pw, String hn, String em) throws IllegalArgumentException {
        if (pw == null || pw.length() == 0) {
            throw new IllegalArgumentException("pw");
        }
        if (hn == null || hn.length() == 0) {
            throw new IllegalArgumentException("hn");
        }
        this.messageType = 1070;
        this.nickname = nn;
        this.password = pw;
        this.email = em != null ? em : "";
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public String toCmd() {
        return SOCCreateAccount.toCmd(this.nickname, this.password, this.host, this.email);
    }

    public static String toCmd(String nn, String pw, String hn, String em) throws IllegalArgumentException {
        if (pw == null || pw.length() == 0) {
            throw new IllegalArgumentException("pw");
        }
        if (hn == null || hn.length() == 0) {
            throw new IllegalArgumentException("hn");
        }
        if (em == null || em.length() == 0) {
            em = "\t";
        }
        return "1070|" + nn + "," + pw + "," + hn + "," + em;
    }

    public static SOCCreateAccount parseDataStr(String s) {
        String em;
        String hn;
        String pw;
        String nn;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            nn = st.nextToken();
            pw = st.nextToken();
            hn = st.nextToken();
            em = st.nextToken();
            if (em.equals("\t")) {
                em = "";
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCCreateAccount(nn, pw, hn, em);
    }

    @Override
    public String toString() {
        String s = "SOCCreateAccount:nickname=" + this.nickname + "|password=***|host=" + this.host + "|email=" + this.email;
        return s;
    }
}

