/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCDebugFreePlace
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1112L;
    public static final int VERSION_FOR_DEBUGFREEPLACE = 1112;
    private String game;
    private int pieceType;
    private int playerNumber;
    private int coordinates;

    public SOCDebugFreePlace(String na, int pn, int pt, int co) throws IllegalArgumentException {
        if (pt < 0) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        if (co < 0) {
            throw new IllegalArgumentException("coord < 0");
        }
        this.messageType = 1087;
        this.game = na;
        this.pieceType = pt;
        this.playerNumber = pn;
        this.coordinates = co;
    }

    public SOCDebugFreePlace(String na, int pn, boolean onOff) {
        this(na, pn, 0, onOff ? 1 : 0);
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPieceType() {
        return this.pieceType;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    @Override
    public String toCmd() {
        return SOCDebugFreePlace.toCmd(this.game, this.playerNumber, this.pieceType, this.coordinates);
    }

    public static String toCmd(String na, int pn, int pt, int co) throws IllegalArgumentException {
        if (pt < 0) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        if (co < 0) {
            throw new IllegalArgumentException("coord < 0");
        }
        return "1087|" + na + "," + pn + "," + pt + "," + co;
    }

    public static SOCDebugFreePlace parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String na = st.nextToken();
            int pn = Integer.parseInt(st.nextToken());
            int pt = Integer.parseInt(st.nextToken());
            int co = Integer.parseInt(st.nextToken());
            return new SOCDebugFreePlace(na, pn, pt, co);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getMinimumVersion() {
        return 1112;
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            ret.append(pieces[i]).append(',');
        }
        ret.append(Integer.parseInt(pieces[3].substring(2), 16));
        return ret.toString();
    }

    @Override
    public String toString() {
        String s = "SOCDebugFreePlace:game=" + this.game + "|playerNumber=" + this.playerNumber + "|pieceType=" + this.pieceType + "|coord=0x" + Integer.toHexString(this.coordinates);
        return s;
    }
}

