/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCDeclinePlayerRequest
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    public static final int MIN_VERSION = 2500;
    public static final int REASON_OTHER = 0;
    public static final int REASON_NOT_THIS_GAME = 1;
    public static final int REASON_NOT_YOUR_TURN = 2;
    public static final int REASON_NOT_NOW = 3;
    public static final int REASON_LOCATION = 4;
    public static final int REASON_SPECIFICS = 5;
    public final String gameName;
    public final int gameState;
    public final int reasonCode;
    public final int detailValue1;
    public final int detailValue2;
    public final String reasonText;

    public SOCDeclinePlayerRequest(String gameName, int gameState, int reasonCode, int detailValue1, int detailValue2, String reasonText) {
        this.messageType = 1104;
        this.gameName = gameName;
        this.gameState = gameState;
        this.reasonCode = reasonCode;
        this.detailValue1 = detailValue1;
        this.detailValue2 = detailValue2;
        this.reasonText = reasonText;
    }

    @Override
    public String getGame() {
        return this.gameName;
    }

    @Override
    public final int getMinimumVersion() {
        return 2500;
    }

    @Override
    public String toCmd() {
        StringBuilder sb = new StringBuilder("1104|" + this.gameName + "," + this.gameState + "," + this.reasonCode);
        if (this.detailValue1 != 0 || this.detailValue2 != 0 || this.reasonText != null) {
            sb.append(',').append(this.detailValue1).append(',').append(this.detailValue2);
            if (this.reasonText != null) {
                sb.append(',').append(this.reasonText);
            }
        }
        return sb.toString();
    }

    public static SOCDeclinePlayerRequest parseDataStr(String cmd) {
        StringTokenizer st = new StringTokenizer(cmd, ",");
        try {
            int detail1 = 0;
            int detail2 = 0;
            String rtext = null;
            String ga = st.nextToken();
            int gaState = Integer.parseInt(st.nextToken());
            int rcode = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                detail1 = Integer.parseInt(st.nextToken());
                detail2 = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens() && (rtext = st.nextToken(Character.toString('\u0001')).trim()).startsWith(",")) {
                    rtext = rtext.substring(1);
                }
            }
            return new SOCDeclinePlayerRequest(ga, gaState, rcode, detail1, detail2, rtext);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCDeclinePlayerRequest:game=" + this.gameName + "|state=" + this.gameState + "|reason=" + this.reasonCode);
        if (this.detailValue1 != 0 || this.detailValue2 != 0 || this.reasonText != null) {
            sb.append("|detail1=").append(this.detailValue1).append("|detail2=").append(this.detailValue2);
            if (this.reasonText != null) {
                sb.append("|text=").append(this.reasonText);
            }
        }
        return sb.toString();
    }
}

