/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCDevCardAction
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2700L;
    public static final int VERSION_FOR_MULTIPLE = 2000;
    public static final int VERSION_FOR_SITDOWN_CLEARS_INVENTORY = 2300;
    public static final int VERSION_FOR_BUY_OMITS_GE_DEV_CARD_COUNT = 2500;
    public static final int MAX_MULTIPLE = 100;
    public static final int DRAW = 0;
    public static final int PLAY = 1;
    public static final int ADD_NEW = 2;
    public static final int ADD_OLD = 3;
    public static final int CANNOT_PLAY = 4;
    public static final int REMOVE_NEW = 5;
    public static final int REMOVE_OLD = 6;
    private String game;
    private int playerNumber;
    private final int cardType;
    private final List<Integer> cardTypes;
    private int actionType;
    public static final String[] ACTION_STRINGS = new String[]{"DRAW", "PLAY", "ADD_NEW", "ADD_OLD", "CANNOT_PLAY", "REMOVE_NEW", "REMOVE_OLD"};

    public SOCDevCardAction(String ga, int pn, int ac, int ct) {
        this.messageType = 1046;
        this.game = ga;
        this.playerNumber = pn;
        this.actionType = ac;
        this.cardType = ct;
        this.cardTypes = null;
    }

    public SOCDevCardAction(String ga, int pn, int ac, List<Integer> ct) throws IllegalArgumentException {
        if (pn < 0) {
            throw new IllegalArgumentException("pn: " + pn);
        }
        if (ac == 1 || ac == 4) {
            throw new IllegalArgumentException("action: " + ac);
        }
        if (ct == null) {
            throw new IllegalArgumentException("ct: null");
        }
        int S = ct.size();
        if (S == 0 || S > 100) {
            throw new IllegalArgumentException("ct size: " + S);
        }
        this.messageType = 1046;
        this.game = ga;
        this.playerNumber = pn;
        this.actionType = ac;
        this.cardType = S != 1 ? 0 : ct.get(0);
        this.cardTypes = S != 1 ? ct : null;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getAction() {
        return this.actionType;
    }

    public int getCardType() {
        return this.cardType;
    }

    public List<Integer> getCardTypes() {
        return this.cardTypes;
    }

    @Override
    public String toCmd() {
        StringBuilder sb = new StringBuilder("1046|" + this.game + "," + this.playerNumber + "," + this.actionType);
        if (this.cardTypes == null) {
            sb.append(",");
            sb.append(this.cardType);
        } else {
            for (Integer ctype : this.cardTypes) {
                sb.append(",");
                sb.append(ctype);
            }
        }
        return sb.toString();
    }

    public static SOCDevCardAction parseDataStr(String s) {
        int ct;
        int ac;
        int pn;
        String ga;
        ArrayList<Integer> ctypes = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            ac = Integer.parseInt(st.nextToken());
            ct = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                ctypes = new ArrayList<Integer>();
                ctypes.add(ct);
                for (int i = 2; st.hasMoreTokens() && i <= 100; ++i) {
                    ctypes.add(Integer.parseInt(st.nextToken()));
                }
                if (st.hasMoreTokens()) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        if (ctypes != null) {
            return new SOCDevCardAction(ga, pn, ac, ctypes);
        }
        return new SOCDevCardAction(ga, pn, ac, ct);
    }

    public static String stripAttribNames(String messageTypeName, String messageStrParams) {
        boolean isV1Format = "SOCDevCard".equals(messageTypeName);
        boolean hasArray = !isV1Format && messageStrParams.indexOf("|cardTypes=[") > 0;
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        if (pieces.length <= 2 || pieces[2].isEmpty()) {
            return s;
        }
        String act = pieces[2];
        int actType = -1;
        for (int ac = 0; ac < ACTION_STRINGS.length; ++ac) {
            if (!ACTION_STRINGS[ac].equals(act)) continue;
            actType = ac;
            break;
        }
        if (actType != -1) {
            pieces[2] = Integer.toString(actType);
        }
        if (hasArray) {
            if (pieces.length == 4) {
                String piece = pieces[3];
                pieces[3] = piece.substring(1, piece.length() - 1);
            } else {
                int ilast = pieces.length - 1;
                for (int i = 3; i < ilast; ++i) {
                    String piece = pieces[i];
                    char ch0 = piece.charAt(0);
                    if (ch0 != '[' && ch0 != ' ') continue;
                    pieces[i] = piece.substring(1);
                }
                String piece = pieces[ilast];
                int charIdxFirst = piece.charAt(0) == ' ' ? 1 : 0;
                int charIdxLast = piece.length() - 1;
                if (charIdxLast >= 0 && piece.charAt(charIdxLast) == ']') {
                    pieces[ilast] = piece.substring(charIdxFirst, charIdxLast);
                }
            }
        } else if (isV1Format) {
            try {
                int cardType = Integer.parseInt(pieces[3]);
                if (cardType == 0) {
                    pieces[3] = Integer.toString(9);
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < pieces.length; ++i) {
            if (i > 0) {
                ret.append(',');
            }
            ret.append(pieces[i]);
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        String act = this.actionType >= 0 && this.actionType < ACTION_STRINGS.length ? ACTION_STRINGS[this.actionType] : Integer.toString(this.actionType);
        return "SOCDevCardAction:game=" + this.game + "|playerNum=" + this.playerNumber + "|actionType=" + act + (this.cardTypes != null ? "|cardTypes=" + this.cardTypes.toString() : "|cardType=" + this.cardType);
    }
}

