/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessageTemplateMi;

public class SOCDiceResultResources
extends SOCMessageTemplateMi {
    public static final int VERSION_FOR_DICERESULTRESOURCES = 2000;
    private static final long serialVersionUID = 2000L;
    public List<Integer> playerNum;
    public List<SOCResourceSet> playerRsrc;
    public List<Integer> playerResTotal;

    public static final SOCDiceResultResources buildForGame(SOCGame ga) {
        ArrayList<Integer> pnum = null;
        ArrayList<SOCResourceSet> rsrc = null;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            SOCPlayer pp;
            SOCResourceSet rs;
            if (ga.isSeatVacant(pn) || (rs = (pp = ga.getPlayer(pn)).getRolledResources()).getKnownTotal() == 0) continue;
            if (pnum == null) {
                pnum = new ArrayList<Integer>();
                rsrc = new ArrayList<SOCResourceSet>();
            }
            pnum.add(pn);
            rsrc.add(rs);
        }
        if (pnum == null) {
            return null;
        }
        ArrayList<Integer> rTotal = new ArrayList<Integer>();
        Iterator iterator = pnum.iterator();
        while (iterator.hasNext()) {
            int pn = (Integer)iterator.next();
            rTotal.add(ga.getPlayer(pn).getResources().getTotal());
        }
        return new SOCDiceResultResources(ga.getName(), pnum, rTotal, rsrc);
    }

    private SOCDiceResultResources(String gaName, List<Integer> pn, List<Integer> rTotal, List<SOCResourceSet> rsrc) throws IllegalArgumentException, NullPointerException {
        super(1092, gaName, SOCDiceResultResources.buildIntList(pn, rTotal, rsrc));
    }

    private SOCDiceResultResources(String gameName, int[] pa) throws IllegalArgumentException {
        super(1092, gameName, pa);
        int plCount = pa[0];
        this.playerNum = new ArrayList<Integer>(plCount);
        this.playerRsrc = new ArrayList<SOCResourceSet>(plCount);
        this.playerResTotal = new ArrayList<Integer>(plCount);
        try {
            int L = pa.length;
            int p = 0;
            int i = 1;
            while (i < L) {
                this.playerNum.add(pa[i]);
                ++p;
                this.playerResTotal.add(pa[++i]);
                SOCResourceSet rsrc = new SOCResourceSet();
                int amount = pa[++i];
                ++i;
                while (amount != 0 && i < L) {
                    rsrc.add(amount, pa[i]);
                    if (++i < L) {
                        amount = pa[i];
                        ++i;
                        continue;
                    }
                    amount = 0;
                }
                this.playerRsrc.add(rsrc);
            }
            if (p != plCount) {
                throw new IllegalArgumentException("player count mismatch");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            IllegalArgumentException iae = new IllegalArgumentException("too short");
            iae.initCause(e);
            throw iae;
        }
    }

    private static final int[] buildIntList(List<Integer> pnum, List<Integer> rTotal, List<SOCResourceSet> rsrc) {
        int n = pnum.size();
        if (n == 0 || n != rsrc.size() || n != rTotal.size()) {
            throw new IllegalArgumentException();
        }
        int len = 3 * n;
        for (SOCResourceSet rs : rsrc) {
            len += 2 * rs.getResourceTypeCount();
        }
        int[] pa = new int[len];
        pa[0] = n;
        int i = 1;
        for (int p = 0; p < n; ++p) {
            pa[i] = pnum.get(p);
            pa[++i] = rTotal.get(p);
            ++i;
            SOCResourceSet rs = rsrc.get(p);
            for (int rtype = 1; rtype <= 5; ++rtype) {
                int amt = rs.getAmount(rtype);
                if (amt == 0) continue;
                pa[i] = amt;
                pa[++i] = rtype;
                ++i;
            }
            if (p == n - 1) continue;
            pa[i] = 0;
            ++i;
        }
        return pa;
    }

    @Override
    public int getMinimumVersion() {
        return 2000;
    }

    public static SOCDiceResultResources parseDataStr(List<String> pa) {
        if (pa == null || pa.size() < 2) {
            return null;
        }
        try {
            String gaName = pa.get(0);
            int[] ipa = new int[pa.size() - 1];
            for (int i = 0; i < ipa.length; ++i) {
                ipa[i] = Integer.parseInt(pa.get(i + 1));
            }
            return new SOCDiceResultResources(gaName, ipa);
        }
        catch (Exception e) {
            return null;
        }
    }
}

