/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.ResourceSet;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCDiscard
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    public static final int VERSION_FOR_OMIT_PLAYERELEMENTS_ALWAYS_GAMESTATE = 2500;
    private String game;
    private int playerNumber = -1;
    private ResourceSet resources;

    public SOCDiscard(String ga, int cl, int or, int sh, int wh, int wo, int uk) {
        this(ga, -1, cl, or, sh, wh, wo, uk);
    }

    public SOCDiscard(String ga, int pn, int cl, int or, int sh, int wh, int wo, int uk) {
        this.messageType = 1033;
        this.game = ga;
        this.playerNumber = pn;
        this.resources = new SOCResourceSet(cl, or, sh, wh, wo, uk);
    }

    public SOCDiscard(String ga, int pn, ResourceSet rs) {
        this.messageType = 1033;
        this.playerNumber = pn;
        this.game = ga;
        this.resources = rs;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public ResourceSet getResources() {
        return this.resources;
    }

    @Override
    public String toCmd() {
        return "1033|" + this.game + "," + (this.playerNumber >= 0 ? "p" + this.playerNumber + "," : "") + this.resources.getAmount(1) + "," + this.resources.getAmount(2) + "," + this.resources.getAmount(3) + "," + this.resources.getAmount(4) + "," + this.resources.getAmount(5) + "," + this.resources.getAmount(6);
    }

    public static SOCDiscard parseDataStr(String s) {
        int uk;
        int wo;
        int wh;
        int sh;
        int or;
        int cl;
        String ga;
        int pn = -1;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            String tok = st.nextToken();
            if (tok.charAt(0) == 'p') {
                pn = Integer.parseInt(tok.substring(1));
                tok = st.nextToken();
            }
            cl = Integer.parseInt(tok);
            or = Integer.parseInt(st.nextToken());
            sh = Integer.parseInt(st.nextToken());
            wh = Integer.parseInt(st.nextToken());
            wo = Integer.parseInt(st.nextToken());
            uk = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCDiscard(ga, pn, cl, or, sh, wh, wo, uk);
    }

    public static String stripAttribNames(String message) {
        int pos = (message = message.replace("resources=", "")).indexOf("|playerNum=");
        if (pos != -1) {
            message = message.substring(0, pos + 2) + message.substring(pos + 11);
        }
        return SOCMessage.stripAttribNames(message);
    }

    @Override
    public String toString() {
        return "SOCDiscard:game=" + this.game + (this.playerNumber >= 0 ? "|playerNum=" + this.playerNumber : "") + "|resources=" + this.resources;
    }
}

