/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCDiscardRequest
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int numDiscards;

    public SOCDiscardRequest(String ga, int nd) {
        this.messageType = 1029;
        this.game = ga;
        this.numDiscards = nd;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getNumberOfDiscards() {
        return this.numDiscards;
    }

    @Override
    public String toCmd() {
        return SOCDiscardRequest.toCmd(this.game, this.numDiscards);
    }

    public static String toCmd(String ga, int nd) {
        return "1029|" + ga + "," + nd;
    }

    public static SOCDiscardRequest parseDataStr(String s) {
        int nd;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            nd = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCDiscardRequest(ga, nd);
    }

    @Override
    public String toString() {
        return "SOCDiscardRequest:game=" + this.game + "|numDiscards=" + this.numDiscards;
    }
}

