/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import soc.message.SOCMessageForGame;
import soc.message.SOCMessageTemplateMi;

public class SOCGameElements
extends SOCMessageTemplateMi
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int MIN_VERSION = 2000;
    private int[] elementTypes;
    private int[] values;

    public SOCGameElements(String ga, GEType[] etypes, int[] values) throws NullPointerException, IllegalArgumentException {
        this(ga, GEType.getValues(etypes), values);
    }

    private SOCGameElements(String ga, int[] etypes, int[] values) throws NullPointerException, IllegalArgumentException {
        super(1096, ga, new int[2 * etypes.length]);
        if (values == null) {
            throw new NullPointerException();
        }
        int L = etypes.length;
        if (values.length != L) {
            throw new IllegalArgumentException("lengths");
        }
        this.elementTypes = etypes;
        this.values = values;
        int pai = 0;
        for (int eti = 0; eti < L; ++eti) {
            this.pa[pai] = etypes[eti];
            this.pa[++pai] = values[eti];
            ++pai;
        }
    }

    public SOCGameElements(String ga, GEType etype, int value) throws NullPointerException {
        this(ga, new int[]{etype.value}, new int[]{value});
    }

    @Override
    public final int getMinimumVersion() {
        return 2000;
    }

    public int[] getElementTypes() {
        return this.elementTypes;
    }

    public int[] getValues() {
        return this.values;
    }

    public static SOCGameElements parseDataStr(List<String> pa) {
        if (pa == null) {
            return null;
        }
        int L = pa.size();
        if (L < 3 || L % 2 == 0) {
            return null;
        }
        try {
            String gaName = pa.get(0);
            int n = (L - 1) / 2;
            int[] elementTypes = new int[n];
            int[] values = new int[n];
            int pai = 1;
            for (int i = 0; i < n; ++i) {
                elementTypes[i] = Integer.parseInt(pa.get(pai));
                values[i] = Integer.parseInt(pa.get(++pai));
                ++pai;
            }
            return new SOCGameElements(gaName, elementTypes, values);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> stripAttribsToList(String messageStrParams) {
        String[] pieces = messageStrParams.split("\\|");
        if (pieces.length != 2) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (!pieces[0].startsWith("game=")) {
            return null;
        }
        ret.add(pieces[0].substring(5));
        pieces = pieces[1].split(",");
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (piece.charAt(0) != 'e') {
                return null;
            }
            int j = piece.indexOf(61);
            if (j < 2) {
                return null;
            }
            ret.add(piece.substring(1, j));
            ret.add(piece.substring(j + 1));
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCGameElements:game=" + this.game + '|');
        for (int i = 0; i < this.pa.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('e');
            sb.append(this.pa[i]);
            sb.append('=');
            sb.append(this.pa[++i]);
        }
        return sb.toString();
    }

    public static enum GEType {
        UNKNOWN_TYPE(0),
        ROUND_COUNT(1),
        DEV_CARD_COUNT(2),
        FIRST_PLAYER(3),
        CURRENT_PLAYER(4),
        LARGEST_ARMY_PLAYER(5),
        LONGEST_ROAD_PLAYER(6),
        SPECIAL_BUILDING_AFTER_PLAYER(7),
        SHIP_PLACED_THIS_TURN_EDGE(8),
        IS_PLACING_ROBBER_FOR_KNIGHT_CARD_FLAG(9),
        HAS_BUILT_CITY_N7C(10);

        public static final int VERSION_FOR_SHIP_PLACED_THIS_TURN_EDGE = 2700;
        private int value;

        private GEType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static GEType valueOf(int ti) {
            for (GEType et : GEType.values()) {
                if (et.value != ti) continue;
                return et;
            }
            return null;
        }

        public static int[] getValues(GEType[] ge) throws NullPointerException {
            if (ge == null) {
                return null;
            }
            int L = ge.length;
            int[] iv = new int[L];
            for (int i = 0; i < L; ++i) {
                iv[i] = ge[i].value;
            }
            return iv;
        }
    }
}

