/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.server.genericServer.Connection;

public class SOCGameMembers
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    private List<String> members;
    private String game;

    public SOCGameMembers(String ga, List<String> ml) {
        this.messageType = 1017;
        this.members = ml;
        this.game = ga;
    }

    public List<String> getMembers() {
        return this.members;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String toCmd() {
        return SOCGameMembers.toCmd(this.game, this.members);
    }

    public static String toCmd(String ga, List<?> ml) {
        String cmd = "1017|" + ga;
        try {
            for (Object obj : ml) {
                String str = obj instanceof Connection ? ((Connection)obj).getData() : (obj instanceof String ? (String)obj : obj.toString());
                cmd = cmd + "," + str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    public static SOCGameMembers parseDataStr(String s) {
        String ga;
        ArrayList<String> ml = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            while (st.hasMoreTokens()) {
                ml.add(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCGameMembers(ga, ml);
    }

    public static String stripAttribNames(String messageStrParams) {
        return SOCGameMembers.stripAttribNamesToMemberList("game=", messageStrParams);
    }

    public static String stripAttribNamesToMemberList(String prefix, String messageStrParams) {
        if (!messageStrParams.startsWith(prefix)) {
            return null;
        }
        int L = messageStrParams.length();
        int pipeIdx = messageStrParams.indexOf(124);
        if (pipeIdx <= 0 || pipeIdx >= L - 11) {
            return null;
        }
        if (!"members=".equals(messageStrParams.subSequence(pipeIdx + 1, pipeIdx + 9))) {
            return null;
        }
        StringBuilder ret = new StringBuilder(messageStrParams.subSequence(prefix.length(), pipeIdx));
        if ('[' != messageStrParams.charAt(pipeIdx + 9)) {
            ret.append(',').append(messageStrParams.substring(pipeIdx + 9));
        } else {
            if (']' != messageStrParams.charAt(L - 1)) {
                return null;
            }
            int prevComma = pipeIdx + 8;
            int commaIdx = messageStrParams.indexOf(", ", prevComma + 2);
            while (commaIdx != -1) {
                ret.append(',').append(messageStrParams.subSequence(prevComma + 2, commaIdx));
                prevComma = commaIdx;
                commaIdx = messageStrParams.indexOf(", ", prevComma + 2);
            }
            ret.append(',').append(messageStrParams.subSequence(prevComma + 2, messageStrParams.length() - 1));
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("SOCGameMembers:game=");
        sb.append(this.game);
        sb.append("|members=");
        if (this.members != null) {
            sb.append(this.members);
        }
        return sb.toString();
    }
}

