/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.game.SOCGameOption;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;
import soc.util.DataUtils;

public class SOCGameOptionGetInfos
extends SOCMessage
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2000L;
    public static final String OPTKEY_GET_I18N_DESCS = "?I18N";
    public static final String OPTKEY_GET_ANY_CHANGES = "?CHANGES";
    public final List<String> optionKeys;
    public final boolean hasTokenGetI18nDescs;
    public final boolean hasOnlyTokenI18n;
    public boolean hasTokenGetAnyChanges;

    public SOCGameOptionGetInfos(List<String> okeys, boolean withTokenI18nDescs, boolean withOnlyTokenI18n) throws IllegalArgumentException {
        if (withOnlyTokenI18n && okeys != null) {
            throw new IllegalArgumentException(okeys.toString());
        }
        this.messageType = 1081;
        this.optionKeys = okeys;
        this.hasTokenGetI18nDescs = withTokenI18nDescs;
        this.hasOnlyTokenI18n = withOnlyTokenI18n;
    }

    public SOCGameOptionGetInfos(List<SOCGameOption> opts, boolean withTokenI18nDescs) {
        this.messageType = 1081;
        if (opts != null) {
            ArrayList<String> okeys = new ArrayList<String>(opts.size());
            for (SOCGameOption opt : opts) {
                okeys.add(opt.key);
            }
            this.optionKeys = okeys;
        } else {
            this.optionKeys = null;
        }
        this.hasTokenGetI18nDescs = withTokenI18nDescs;
        this.hasOnlyTokenI18n = false;
    }

    @Override
    public int getMinimumVersion() {
        return 1107;
    }

    public boolean hasTokenGetI18nDescs() {
        return this.hasTokenGetI18nDescs;
    }

    @Override
    public String toCmd() {
        StringBuilder cmd = new StringBuilder();
        cmd.append(1081).append("|");
        if (this.optionKeys == null || this.optionKeys.isEmpty()) {
            if (!this.hasOnlyTokenI18n) {
                cmd.append("-");
            }
        } else {
            boolean hadAny = false;
            for (String key : this.optionKeys) {
                if (hadAny) {
                    cmd.append(",");
                } else {
                    hadAny = true;
                }
                cmd.append(key);
            }
        }
        if (this.hasTokenGetI18nDescs) {
            if (!this.hasOnlyTokenI18n) {
                cmd.append(",");
            }
            cmd.append(OPTKEY_GET_I18N_DESCS);
        }
        return cmd.toString();
    }

    public static SOCGameOptionGetInfos parseDataStr(String s) {
        ArrayList<String> okey = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        boolean hasDash = false;
        boolean hasTokenI18n = false;
        boolean hasTokenAllChanges = false;
        try {
            while (st.hasMoreTokens()) {
                String ntok = st.nextToken();
                if (ntok.equals("-")) {
                    hasDash = true;
                    continue;
                }
                if (ntok.equals(OPTKEY_GET_I18N_DESCS)) {
                    hasTokenI18n = true;
                    continue;
                }
                if (ntok.equals(OPTKEY_GET_ANY_CHANGES)) {
                    hasTokenAllChanges = true;
                    continue;
                }
                okey.add(ntok);
            }
        }
        catch (Exception e) {
            System.err.println("SOCGameOptionGetInfos parseDataStr ERROR - " + e);
            return null;
        }
        if (okey.isEmpty()) {
            okey = null;
        }
        if (hasDash && okey != null) {
            return null;
        }
        SOCGameOptionGetInfos ret = new SOCGameOptionGetInfos(okey, hasTokenI18n, hasTokenI18n && okey == null && !hasDash);
        if (hasTokenAllChanges) {
            ret.hasTokenGetAnyChanges = true;
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCGameOptionGetInfos:options=");
        if (this.optionKeys == null) {
            if (!this.hasOnlyTokenI18n) {
                sb.append('-');
            }
        } else {
            DataUtils.listIntoStringBuilder(this.optionKeys, sb);
            if (this.hasTokenGetAnyChanges && !this.optionKeys.contains(OPTKEY_GET_ANY_CHANGES)) {
                sb.append(',').append(OPTKEY_GET_ANY_CHANGES);
            }
        }
        if (this.hasTokenGetI18nDescs) {
            if (!this.hasOnlyTokenI18n) {
                sb.append(',');
            }
            sb.append(OPTKEY_GET_I18N_DESCS);
        }
        return sb.toString();
    }
}

