/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import soc.game.SOCGameOption;
import soc.message.SOCMessageTemplateMs;

public class SOCGameOptionInfo
extends SOCMessageTemplateMs {
    private static final long serialVersionUID = 2000L;
    public static final SOCGameOptionInfo OPTINFO_NO_MORE_OPTS = new SOCGameOptionInfo(new SOCGameOption("-", null), 0, null);
    protected SOCGameOption opt = null;

    public SOCGameOptionInfo(SOCGameOption op, int cliVers, String localDesc) {
        super(1082, new ArrayList<String>());
        this.opt = op;
        this.pa.add(op.key);
        this.pa.add(Integer.toString(op.optType));
        this.pa.add(Integer.toString(op.minVersion));
        this.pa.add(Integer.toString(op.lastModVersion));
        this.pa.add(op.defaultBoolValue ? "t" : "f");
        this.pa.add(Integer.toString(op.defaultIntValue));
        this.pa.add(Integer.toString(op.minIntValue));
        this.pa.add(Integer.toString(op.maxIntValue));
        this.pa.add(op.getBoolValue() ? "t" : "f");
        if (op.optType == 6 || op.optType == 7) {
            this.pa.add(op.getStringValue());
        } else {
            this.pa.add(Integer.toString(op.getIntValue()));
        }
        if (cliVers < 2000) {
            this.pa.add(op.hasFlag(1) ? "t" : "f");
        } else {
            this.pa.add(Integer.toString(op.optFlags));
        }
        this.pa.add(localDesc != null ? localDesc : op.getDesc());
        if (op.optType == 4 || op.optType == 5) {
            for (String ev : op.enumVals) {
                this.pa.add(ev);
            }
        }
    }

    protected SOCGameOptionInfo(List<String> pal) throws IllegalArgumentException, NumberFormatException {
        super(1082, pal);
        String sval_cur;
        int ival_cur;
        int L = pal.size();
        if (L < 11) {
            throw new IllegalArgumentException("pal.size");
        }
        SOCGameOptionInfo.parseData_FindEmptyStrs(pal);
        String[] params = pal.toArray(new String[L]);
        int otyp = Integer.parseInt(params[1]);
        if (otyp < 0 || otyp > 7) {
            otyp = 0;
        }
        int oversmin = Integer.parseInt(params[2]);
        int oversmod = Integer.parseInt(params[3]);
        boolean bval_def = params[4].equals("t");
        int ival_def = Integer.parseInt(params[5]);
        int ival_min = Integer.parseInt(params[6]);
        int ival_max = Integer.parseInt(params[7]);
        boolean bval_cur = params[8].equals("t");
        if (otyp == 6 || otyp == 7) {
            ival_cur = 0;
            sval_cur = params[9];
            if (sval_cur.length() == 0) {
                sval_cur = null;
            }
        } else {
            ival_cur = Integer.parseInt(params[9]);
            sval_cur = null;
        }
        int opt_flags = params[10].equals("t") ? 1 : (params[10].equals("f") || params[10].length() == 0 ? 0 : Integer.parseInt(params[10]));
        if (params.length != 11 && params.length != 12 && otyp != 4 && otyp != 5) {
            throw new IllegalArgumentException("params.length");
        }
        switch (otyp) {
            case 0: {
                this.opt = new SOCGameOption(params[0], params.length > 11 ? params[11] : null);
                break;
            }
            case 1: {
                this.opt = new SOCGameOption(params[0], oversmin, oversmod, bval_def, opt_flags, params[11]);
                this.opt.setBoolValue(bval_cur);
                break;
            }
            case 2: {
                this.opt = new SOCGameOption(params[0], oversmin, oversmod, ival_def, ival_min, ival_max, opt_flags, params[11]);
                this.opt.setIntValue(ival_cur);
                break;
            }
            case 3: {
                this.opt = new SOCGameOption(params[0], oversmin, oversmod, bval_def, ival_def, ival_min, ival_max, opt_flags, params[11]);
                this.opt.setBoolValue(bval_cur);
                this.opt.setIntValue(ival_cur);
                break;
            }
            case 4: {
                String[] choices = new String[ival_max];
                System.arraycopy(params, 12, choices, 0, ival_max);
                this.opt = new SOCGameOption(params[0], oversmin, oversmod, ival_def, choices, opt_flags, params[11]);
                this.opt.setIntValue(ival_cur);
                break;
            }
            case 5: {
                String[] choices = new String[ival_max];
                System.arraycopy(params, 12, choices, 0, ival_max);
                this.opt = new SOCGameOption(params[0], oversmin, oversmod, bval_def, ival_def, choices, opt_flags, params[11]);
                this.opt.setBoolValue(bval_cur);
                this.opt.setIntValue(ival_cur);
                break;
            }
            case 6: 
            case 7: {
                this.opt = new SOCGameOption(params[0], oversmin, oversmod, ival_max, otyp == 7, opt_flags, params[11]);
                this.opt.setStringValue(sval_cur);
                break;
            }
            default: {
                throw new IllegalArgumentException("optType");
            }
        }
    }

    @Override
    public int getMinimumVersion() {
        return 1107;
    }

    public String getOptionNameKey() {
        return (String)this.pa.get(0);
    }

    public SOCGameOption getOptionInfo() {
        return this.opt;
    }

    public static SOCGameOptionInfo parseDataStr(List<String> pa) {
        if (pa == null || pa.size() < 11) {
            return null;
        }
        try {
            return new SOCGameOptionInfo(pa);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

