/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCGameServerText
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int VERSION_FOR_GAMESERVERTEXT = 2000;
    public static final String UNLIKELY_CHAR1 = Character.toString('\u0001');
    private final String game;
    private final String text;

    public SOCGameServerText(String ga, String tm) {
        this.messageType = 1091;
        this.game = ga;
        this.text = tm;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String toCmd() {
        return SOCGameServerText.toCmd(this.game, this.text);
    }

    public static String toCmd(String ga, String tm) {
        return "1091|" + ga + UNLIKELY_CHAR1 + tm;
    }

    public static SOCGameServerText parseDataStr(String s) {
        String tm;
        String ga;
        StringTokenizer st = new StringTokenizer(s, UNLIKELY_CHAR1);
        try {
            ga = st.nextToken();
            tm = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCGameServerText(ga, tm);
    }

    public static String stripAttribNames(String messageStrParams) {
        if (!messageStrParams.startsWith("game=")) {
            return messageStrParams;
        }
        int i = messageStrParams.indexOf("|text=");
        if (i <= 0) {
            return messageStrParams;
        }
        String ga = messageStrParams.substring(5, i);
        String tm = messageStrParams.substring(i + 6);
        return ga + UNLIKELY_CHAR1 + tm;
    }

    @Override
    public String toString() {
        return "SOCGameServerText:game=" + this.game + "|text=" + this.text;
    }

    @Override
    public final int getMinimumVersion() {
        return 2000;
    }
}

