/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCGameStats
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2700L;
    public static final int VERSION_FOR_TYPE_TIMING = 2700;
    public static final int TYPE_PLAYERS = 1;
    public static final int TYPE_TIMING = 2;
    private String game;
    private final int statType;
    private final long[] scores;
    private final boolean[] robots;

    public SOCGameStats(String ga, int[] sc, boolean[] rb) {
        this.messageType = 1061;
        this.game = ga;
        this.statType = 1;
        long[] sco = new long[sc.length];
        for (int i = 0; i < sc.length; ++i) {
            sco[i] = sc[i];
        }
        this.scores = sco;
        this.robots = rb;
    }

    public SOCGameStats(String ga, int stype, long[] vals) {
        if (stype == 1 || stype <= 0) {
            throw new IllegalArgumentException("stype");
        }
        if (vals == null) {
            vals = new long[]{};
        }
        this.messageType = 1061;
        this.game = ga;
        this.statType = stype;
        this.scores = vals;
        this.robots = null;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getStatType() {
        return this.statType;
    }

    public long[] getScores() {
        return this.scores;
    }

    public boolean[] getRobotSeats() {
        return this.robots;
    }

    @Override
    public String toCmd() {
        int i;
        StringBuilder sb = new StringBuilder("1061|" + this.game);
        if (this.statType != 1) {
            sb.append(",");
            sb.append('t');
            sb.append(this.statType);
        }
        for (i = 0; i < this.scores.length; ++i) {
            sb.append(",").append(this.scores[i]);
        }
        if (this.statType == 1) {
            for (i = 0; i < this.robots.length; ++i) {
                sb.append(",").append(this.robots[i]);
            }
        }
        return sb.toString();
    }

    public static SOCGameStats parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String ga = st.nextToken();
            String tok = st.nextToken();
            char ch = tok.charAt(0);
            if (ch == 't') {
                ch = tok.charAt(1);
                if (ch < '0' || ch > '9') {
                    return null;
                }
                int stype = Integer.parseInt(tok.substring(1));
                if (stype == 1) {
                    return null;
                }
                int n = st.countTokens();
                long[] sv = new long[n];
                for (int i = 0; i < n; ++i) {
                    sv[i] = Long.parseLong(st.nextToken());
                }
                return new SOCGameStats(ga, stype, sv);
            }
            if (ch >= '0' && ch <= '9') {
                int i;
                int maxPlayers = (st.countTokens() + 1) / 2;
                int[] sc = new int[maxPlayers];
                boolean[] rb = new boolean[maxPlayers];
                sc[0] = Integer.parseInt(tok);
                for (i = 1; i < maxPlayers; ++i) {
                    sc[i] = Integer.parseInt(st.nextToken());
                }
                for (i = 0; i < maxPlayers; ++i) {
                    rb[i] = Boolean.valueOf(st.nextToken());
                }
                return new SOCGameStats(ga, sc, rb);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stripAttribNames(String message) {
        message = message.replace("|stype=", "|stype=t");
        return SOCMessage.stripAttribNames(message);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder text = new StringBuilder("SOCGameStats:game=");
        text.append(this.game);
        if (this.statType != 1) {
            text.append("|stype=").append(this.statType);
        }
        for (i = 0; i < this.scores.length; ++i) {
            text.append("|");
            text.append(this.scores[i]);
        }
        if (this.statType == 1) {
            for (i = 0; i < this.robots.length; ++i) {
                text.append("|");
                text.append(this.robots[i]);
            }
        }
        return text.toString();
    }
}

