/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCGameTextMsg
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final String SERVERNAME = "Server";
    public static final String SERVER_FOR_CHAT = ":";
    public static final int VERSION_FOR_DICE_RESULT_INSTEAD = 2000;
    private static String sep2_alt = "\u0000";
    private String game;
    private String nickname;
    private String text;

    public SOCGameTextMsg(String ga, String nn, String tm) {
        this.messageType = 1010;
        this.game = ga;
        this.nickname = nn;
        this.text = tm;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String toCmd() {
        return "1010|" + this.game + sep2_alt + this.nickname + sep2_alt + this.text;
    }

    public static SOCGameTextMsg parseDataStr(String s) {
        String tm;
        String nn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, sep2_alt);
        try {
            ga = st.nextToken();
            nn = st.nextToken();
            tm = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCGameTextMsg(ga, nn, tm);
    }

    public static String stripAttribNames(String messageStrParams) {
        return SOCGameTextMsg.stripAttribNamesToTextMsg("game=", messageStrParams);
    }

    public static String stripAttribNamesToTextMsg(String prefix, String messageStrParams) {
        if (!messageStrParams.startsWith(prefix)) {
            return null;
        }
        int pipeIdx = messageStrParams.indexOf("|nickname=");
        if (pipeIdx < 0) {
            return null;
        }
        int pipe2Idx = messageStrParams.indexOf("|text=", pipeIdx + 10);
        if (pipe2Idx < 0) {
            return null;
        }
        return messageStrParams.substring(prefix.length(), pipeIdx) + sep2_alt + messageStrParams.substring(pipeIdx + 10, pipe2Idx) + sep2_alt + messageStrParams.substring(pipe2Idx + 6);
    }

    @Override
    public String toString() {
        String s = "SOCGameTextMsg:game=" + this.game + "|nickname=" + this.nickname + "|text=" + this.text;
        return s;
    }
}

