/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.game.SOCGame;
import soc.message.SOCMessage;

public class SOCGames
extends SOCMessage {
    private static final long serialVersionUID = 2000L;
    public static final char MARKER_THIS_GAME_UNJOINABLE = '?';
    public static final int VERSION_FOR_UNJOINABLE = 1106;
    private List<String> games;

    public SOCGames(List<?> ga) {
        this(new ArrayList<String>(), false);
        for (Object ob : ga) {
            if (ob instanceof SOCGame) {
                this.games.add(((SOCGame)ob).getName());
                continue;
            }
            this.games.add(ob.toString());
        }
    }

    private SOCGames(List<String> ga, boolean clientMarker) {
        this.messageType = 1019;
        this.games = ga;
    }

    public List<String> getGames() {
        return this.games;
    }

    @Override
    public String toCmd() {
        StringBuilder cmd = new StringBuilder();
        cmd.append(1019);
        cmd.append("|");
        boolean first = true;
        for (String ob : this.games) {
            if (!first) {
                cmd.append(",");
            } else {
                first = false;
            }
            if (ob instanceof SOCGame) {
                cmd.append(((SOCGame)((Object)ob)).getName());
                continue;
            }
            cmd.append(ob.toString());
        }
        return cmd.toString();
    }

    public static SOCGames parseDataStr(String s) {
        ArrayList<String> ga = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            while (st.hasMoreTokens()) {
                ga.add(st.nextToken());
            }
        }
        catch (Exception e) {
            System.err.println("SOCGames parseDataStr ERROR - " + e);
            return null;
        }
        return new SOCGames(ga, true);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCGames:games=");
        if (this.games != null) {
            sb.append(this.games);
        }
        return sb.toString();
    }
}

