/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.message.SOCMessageTemplateMs;
import soc.util.SOCGameList;

public class SOCGamesWithOptions
extends SOCMessageTemplateMs {
    private static final long serialVersionUID = 2000L;

    public SOCGamesWithOptions(List<?> gamesToSend, int cliVers) {
        this(null);
        this.pa = new ArrayList();
        boolean isJoinable = true;
        for (Object ob : gamesToSend) {
            if (ob instanceof Boolean) {
                isJoinable = (Boolean)ob;
                continue;
            }
            if (ob instanceof SOCGame) {
                SOCGame ga = (SOCGame)ob;
                SOCGameOptionSet opts = ga.getGameOptions();
                String gaName = ga.getName();
                if (!isJoinable) {
                    gaName = '?' + gaName;
                    isJoinable = true;
                }
                this.pa.add(gaName);
                this.pa.add(SOCGameOption.packOptionsToString(opts != null ? opts.getAll() : null, false, false, cliVers));
                continue;
            }
            this.pa.add((String)ob);
            this.pa.add("-");
        }
    }

    private SOCGamesWithOptions(List<String> gl) {
        super(1083, SOCGamesWithOptions.parseData_FindEmptyStrs(gl));
    }

    public SOCGameList getGameList(SOCGameOptionSet knownOpts) {
        SOCGameList gamelist = new SOCGameList(knownOpts);
        int L = this.pa.size();
        for (int ii = 0; ii < L; ++ii) {
            String gaName = (String)this.pa.get(ii);
            gamelist.addGame(gaName, (String)this.pa.get(++ii), false);
        }
        return gamelist;
    }

    @Override
    public int getMinimumVersion() {
        return 1107;
    }

    public static SOCGamesWithOptions parseDataStr(List<String> gl) {
        if (gl == null) {
            gl = new ArrayList<String>();
        } else if (gl.size() % 2 != 0) {
            return null;
        }
        return new SOCGamesWithOptions(gl);
    }
}

