/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;

public class SOCImARobot
extends SOCMessage
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 1119L;
    public static final String RBCLASS_BUILTIN = "soc.robot.SOCRobotBrain";
    private String nickname;
    private final String cookie;
    private String rbclass;

    public SOCImARobot(String nn, String cookie, String rbclass) throws IllegalArgumentException {
        if (cookie != null) {
            if (!SOCMessage.isSingleLineAndSafe(cookie)) {
                throw new IllegalArgumentException("cookie");
            }
            if (rbclass == null) {
                throw new IllegalArgumentException("null rbclass");
            }
        }
        this.messageType = 1022;
        this.nickname = nn;
        this.cookie = cookie;
        this.rbclass = rbclass;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getRBClass() {
        return this.rbclass;
    }

    @Override
    public String toCmd() {
        return SOCImARobot.toCmd(this.nickname, this.cookie, this.rbclass);
    }

    public static String toCmd(String nn, String cookie, String rbclass) {
        if (cookie != null) {
            return "1022|" + nn + "," + cookie + "," + rbclass;
        }
        if (rbclass == null) {
            return "1022|" + nn;
        }
        return "1022|" + nn + "," + rbclass;
    }

    public static SOCImARobot parseDataStr(String s) {
        String nn;
        String cook = null;
        String rbc = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            nn = st.nextToken();
            if (st.hasMoreTokens()) {
                cook = st.nextToken();
                if (st.hasMoreTokens()) {
                    rbc = st.nextToken();
                } else {
                    rbc = cook;
                    cook = null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCImARobot(nn, cook, rbc);
    }

    @Override
    public String toString() {
        String s = this.cookie != null ? "SOCImARobot:nickname=" + this.nickname + "|cookie=**|rbclass=" + this.rbclass : "SOCImARobot:nickname=" + this.nickname + "|cookie=null|rbclass=" + this.rbclass;
        return s;
    }
}

