/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCInventoryItemAction
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int BUY = 1;
    public static final int ADD_PLAYABLE = 2;
    public static final int ADD_OTHER = 3;
    public static final int PLAY = 4;
    public static final int CANNOT_PLAY = 5;
    public static final int PLAYED = 6;
    public static final int PLACING_EXTRA = 7;
    public static final int REMOVE_PLAYABLE = 8;
    public static final int REMOVE_OTHER = 9;
    private static final int FLAG_ISKEPT = 1;
    private static final int FLAG_ISVP = 2;
    private static final int FLAG_CANCPLAY = 4;
    private final String game;
    public final int playerNumber;
    public final int itemType;
    public final int action;
    public final int reasonCode;
    public final boolean isKept;
    public final boolean isVP;
    public final boolean canCancelPlay;

    public SOCInventoryItemAction(String ga, int pn, int ac, int it) {
        this(ga, pn, ac, it, 0);
    }

    public SOCInventoryItemAction(String ga, int pn, int ac, int it, boolean kept, boolean vp, boolean canCancel) {
        this.messageType = 1098;
        this.game = ga;
        this.playerNumber = pn;
        this.action = ac;
        this.itemType = it;
        this.reasonCode = (kept ? 1 : 0) | (vp ? 2 : 0) | (canCancel ? 4 : 0);
        this.isKept = kept;
        this.isVP = vp;
        this.canCancelPlay = canCancel;
    }

    public SOCInventoryItemAction(String ga, int pn, int ac, int it, int rc) {
        this.messageType = 1098;
        this.game = ga;
        this.playerNumber = pn;
        this.action = ac;
        this.itemType = it;
        this.reasonCode = rc;
        this.isKept = false;
        this.isVP = false;
        this.canCancelPlay = false;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String toCmd() {
        return SOCInventoryItemAction.toCmd(this.game, this.playerNumber, this.action, this.itemType, this.reasonCode);
    }

    public static String toCmd(String ga, int pn, int ac, int it, int rc) {
        String cmd = "1098|" + ga + "," + pn + "," + ac + "," + it;
        if (rc != 0) {
            cmd = cmd + "," + rc;
        }
        return cmd;
    }

    public static SOCInventoryItemAction parseDataStr(String s) {
        int it;
        int ac;
        int pn;
        String ga;
        int rc = 0;
        boolean actionHasFlags = false;
        boolean kept = false;
        boolean vp = false;
        boolean canCancel = false;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            ac = Integer.parseInt(st.nextToken());
            it = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                rc = Integer.parseInt(st.nextToken());
                if (ac != 4 && ac != 5) {
                    actionHasFlags = true;
                    kept = (rc & 1) != 0;
                    vp = (rc & 2) != 0;
                    canCancel = (rc & 4) != 0;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        if (actionHasFlags) {
            return new SOCInventoryItemAction(ga, pn, ac, it, kept, vp, canCancel);
        }
        return new SOCInventoryItemAction(ga, pn, ac, it, rc);
    }

    @Override
    public String toString() {
        String ac;
        switch (this.action) {
            case 1: {
                ac = "BUY";
                break;
            }
            case 2: {
                ac = "ADD_PLAYABLE";
                break;
            }
            case 3: {
                ac = "ADD_OTHER";
                break;
            }
            case 4: {
                ac = "PLAY";
                break;
            }
            case 5: {
                ac = "CANNOT_PLAY";
                break;
            }
            case 6: {
                ac = "PLAYED";
                break;
            }
            case 7: {
                ac = "PLACING_EXTRA";
                break;
            }
            case 8: {
                ac = "REMOVE_PLAYABLE";
                break;
            }
            case 9: {
                ac = "REMOVE_OTHER";
                break;
            }
            default: {
                ac = Integer.toString(this.action);
            }
        }
        String s = "SOCInventoryItemAction:game=" + this.game + "|playerNum=" + this.playerNumber + "|action=" + ac + "|itemType=" + this.itemType;
        s = this.action != 4 && this.action != 5 ? s + "|kept=" + this.isKept + "|isVP=" + this.isVP + "|canCancel=" + this.canCancelPlay : s + "|rc=" + this.reasonCode;
        return s;
    }
}

