/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;

public class SOCJoinChannel
extends SOCMessage
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2000L;
    private String nickname;
    private String password;
    private String channel;
    private String host;

    public SOCJoinChannel(String nn, String pw, String hn, String ch) {
        this.messageType = 1004;
        this.nickname = nn;
        this.password = pw;
        this.channel = ch;
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        return SOCJoinChannel.toCmd(this.nickname, this.password, this.host, this.channel);
    }

    public static String toCmd(String nn, String pw, String hn, String ch) {
        String temppw = pw;
        if (pw.length() == 0) {
            temppw = "\t";
        }
        return "1004|" + nn + "," + temppw + "," + hn + "," + ch;
    }

    public static SOCJoinChannel parseDataStr(String s) {
        String ch;
        String hn;
        String pw;
        String nn;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            nn = st.nextToken();
            pw = st.nextToken();
            hn = st.nextToken();
            ch = st.nextToken();
            if (pw.equals("\t")) {
                pw = "";
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCJoinChannel(nn, pw, hn, ch);
    }

    public static String stripAttribNames(String messageStrParams) {
        int pwEmptyIdx = messageStrParams.indexOf("|password empty|host=");
        if (pwEmptyIdx > 0) {
            messageStrParams = messageStrParams.substring(0, pwEmptyIdx + 1) + "\t" + messageStrParams.substring(pwEmptyIdx + 15);
        }
        return SOCMessage.stripAttribNames(messageStrParams);
    }

    @Override
    public String toString() {
        String pwmask = this.password == null || this.password.length() == 0 || this.password.equals("\t") ? "|password empty" : "|password=***";
        String s = "SOCJoinChannel:nickname=" + this.nickname + pwmask + "|host=" + this.host + "|channel=" + this.channel;
        return s;
    }
}

