/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCJoinGameAuth
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    private final String game;
    private final int boardHeight;
    private final int boardWidth;
    private final int[] layoutVS;

    public SOCJoinGameAuth(String gaName) {
        this(gaName, 0, 0, null);
    }

    public SOCJoinGameAuth(String gaName, int height, int width, int[] layoutVS) throws IllegalArgumentException {
        this.messageType = 1021;
        this.game = gaName;
        this.boardHeight = height;
        this.boardWidth = width;
        if (layoutVS != null && layoutVS.length < 2) {
            throw new IllegalArgumentException("layoutVS");
        }
        this.layoutVS = layoutVS;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getBoardHeight() {
        return this.boardHeight;
    }

    public int getBoardWidth() {
        return this.boardWidth;
    }

    public int[] getLayoutVS() {
        return this.layoutVS;
    }

    @Override
    public String toCmd() {
        StringBuilder sb = new StringBuilder("1021|" + this.game);
        if (this.boardHeight != 0 || this.boardWidth != 0) {
            sb.append(',');
            sb.append(this.boardHeight);
            sb.append(',');
            sb.append(this.boardWidth);
            if (this.layoutVS != null) {
                sb.append(',');
                sb.append('S');
                for (int elem : this.layoutVS) {
                    sb.append(',');
                    sb.append(elem);
                }
            }
        }
        return sb.toString();
    }

    public static SOCJoinGameAuth parseDataStr(String s) {
        if (-1 == s.indexOf(44)) {
            return new SOCJoinGameAuth(s, 0, 0, null);
        }
        try {
            int[] vs;
            StringTokenizer st = new StringTokenizer(s, ",");
            String gaName = st.nextToken();
            int bh = Integer.parseInt(st.nextToken());
            int bw = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                if (!st.nextToken().equals("S")) {
                    return null;
                }
                ArrayList<String> rest = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    rest.add(st.nextToken());
                }
                int L = rest.size();
                if (L < 2) {
                    return null;
                }
                vs = new int[L];
                for (int i = 0; i < L; ++i) {
                    vs[i] = Integer.parseInt((String)rest.get(i));
                }
            } else {
                vs = null;
            }
            return new SOCJoinGameAuth(gaName, bh, bw, vs);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String stripAttribNames(String messageStrParams) {
        boolean hasVS = messageStrParams.indexOf("|vs=[") > 0;
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null || !hasVS) {
            return s;
        }
        int i = s.indexOf(",[");
        if (i <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, i + 1));
        i += 2;
        int L = s.length() - 1;
        if (s.charAt(L) != ']') {
            return s;
        }
        sb.append("S,");
        while (i < L) {
            char ch = s.charAt(i);
            if (ch != ' ') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCJoinGameAuth:game=" + this.game);
        if (this.boardHeight != 0 || this.boardWidth != 0) {
            sb.append("|bh=" + this.boardHeight + "|bw=" + this.boardWidth);
            if (this.layoutVS != null) {
                sb.append("|vs=" + Arrays.toString(this.layoutVS));
            }
        }
        return sb.toString();
    }
}

