/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCLastSettlement
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int playerNumber;
    private int coordinates;

    public SOCLastSettlement(String na, int pn, int co) {
        this.messageType = 1060;
        this.game = na;
        this.playerNumber = pn;
        this.coordinates = co;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    @Override
    public String toCmd() {
        return SOCLastSettlement.toCmd(this.game, this.playerNumber, this.coordinates);
    }

    public static String toCmd(String na, int pn, int co) {
        return "1060|" + na + "," + pn + "," + co;
    }

    public static SOCLastSettlement parseDataStr(String s) {
        int co;
        int pn;
        String na;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            na = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            co = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCLastSettlement(na, pn, co);
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        if (pieces.length < 3) {
            return null;
        }
        pieces[2] = Integer.toString(Integer.parseInt(pieces[2], 16));
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < pieces.length; ++i) {
            ret.append(pieces[i]).append(',');
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        String s = "SOCLastSettlement:game=" + this.game + "|playerNumber=" + this.playerNumber + "|coord=" + Integer.toHexString(this.coordinates);
        return s;
    }
}

