/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCLeaveChannel
extends SOCMessage {
    private static final long serialVersionUID = 2000L;
    private String nickname;
    private String channel;
    private String host;

    public SOCLeaveChannel(String nn, String hn, String ch) {
        this.messageType = 1006;
        this.nickname = nn;
        this.channel = ch;
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getHost() {
        return this.host;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        return SOCLeaveChannel.toCmd(this.nickname, this.host, this.channel);
    }

    public static String toCmd(String nn, String hn, String ch) {
        return "1006|" + nn + "," + hn + "," + ch;
    }

    public static SOCLeaveChannel parseDataStr(String s) {
        String ch;
        String hn;
        String nn;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            nn = st.nextToken();
            hn = st.nextToken();
            ch = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCLeaveChannel(nn, hn, ch);
    }

    @Override
    public String toString() {
        String s = "SOCLeaveChannel:nickname=" + this.nickname + "|host=" + this.host + "|channel=" + this.channel;
        return s;
    }
}

