/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import soc.message.SOCMessageFromUnauthClient;
import soc.message.SOCMessageTemplateMs;

public class SOCLocalizedStrings
extends SOCMessageTemplateMs
implements SOCMessageFromUnauthClient {
    public static final String TYPE_GAMEOPT = "O";
    public static final String TYPE_SCENARIO = "S";
    private static final char MARKER_PREFIX = '\u0016';
    public static final int FLAG_TYPE_UNKNOWN = 1;
    public static final int FLAG_REQ_ALL = 2;
    public static final int FLAG_SENT_ALL = 4;
    public static final String MARKER_KEY_UNKNOWN = "\u0016K";
    private static final long serialVersionUID = 2000L;
    private int flags;

    public SOCLocalizedStrings(String type, int flags, String str) throws IllegalArgumentException, NullPointerException {
        this(type, flags, (List<String>)null);
        if (str == null) {
            throw new NullPointerException("str");
        }
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(str);
        SOCLocalizedStrings.checkParams(type, strs);
        this.pa.add(str);
    }

    public SOCLocalizedStrings(String type, int flags, List<String> strs) throws IllegalArgumentException {
        super(1100, strs != null ? new ArrayList<String>(strs) : new ArrayList());
        SOCLocalizedStrings.checkParams(type, strs);
        this.pa.add(0, type);
        this.flags = flags;
    }

    private SOCLocalizedStrings(List<String> strs) throws NumberFormatException {
        super(1100, SOCLocalizedStrings.parseData_FindEmptyStrs(strs));
        this.flags = Integer.parseInt(strs.get(1), 16);
        strs.remove(1);
    }

    public final boolean isFlagSet(int flag) {
        return 0 != (this.flags & flag);
    }

    @Override
    public final int getMinimumVersion() {
        return 2000;
    }

    public static SOCLocalizedStrings parseDataStr(List<String> strs) {
        if (strs == null || strs.size() < 2) {
            return null;
        }
        try {
            return new SOCLocalizedStrings(strs);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toCmd(String type, int flags, List<String> strs, boolean skipFirstStr) {
        StringBuilder sb = new StringBuilder(Integer.toString(1100));
        sb.append("|");
        sb.append(type);
        sb.append("|");
        sb.append(Integer.toHexString(flags));
        if (strs != null) {
            for (int i = 0; i < strs.size(); ++i) {
                if (i == 0 && skipFirstStr) continue;
                sb.append("|");
                String itm = strs.get(i);
                if (itm == null || itm.length() == 0) {
                    itm = "\t";
                }
                sb.append(itm);
            }
        }
        return sb.toString();
    }

    @Override
    public String toCmd() {
        return SOCLocalizedStrings.toCmd((String)this.pa.get(0), this.flags, this.pa, true);
    }

    private static void checkParams(String type, List<String> strs) throws IllegalArgumentException {
        if (!SOCLocalizedStrings.isSingleLineAndSafe(type)) {
            throw new IllegalArgumentException("type: " + type);
        }
        if (strs == null) {
            return;
        }
        for (int i = 0; i < strs.size(); ++i) {
            String itm = strs.get(i);
            if (itm == null || itm.length() == 0 || !(itm.charAt(0) == '\u0016' ? !itm.equals(MARKER_KEY_UNKNOWN) : itm.indexOf(124) != -1 || !SOCLocalizedStrings.isSingleLineAndSafe(itm, true))) continue;
            throw new IllegalArgumentException("item " + i + ": " + itm);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCLocalizedStrings:type=");
        sb.append((String)this.pa.get(0));
        sb.append("|flags=0x").append(Integer.toHexString(this.flags));
        int L = this.pa.size();
        if (L < 2) {
            sb.append("|(strs empty)");
        } else {
            sb.append("|strs=");
            for (int i = 1; i < L; ++i) {
                String p;
                if (i > 1) {
                    sb.append('|');
                }
                sb.append((p = (String)this.pa.get(i)) != null ? p : "(null)");
            }
        }
        return sb.toString();
    }
}

