/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCMakeOffer
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private SOCTradeOffer offer;

    public SOCMakeOffer(String ga, SOCTradeOffer of) {
        this.messageType = 1041;
        this.game = ga;
        this.offer = of;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCTradeOffer getOffer() {
        return this.offer;
    }

    @Override
    public String toCmd() {
        return SOCMakeOffer.toCmd(this.game, this.offer);
    }

    public static String toCmd(String ga, SOCTradeOffer of) {
        String cmd = "1041|" + ga;
        cmd = cmd + "," + of.getFrom();
        boolean[] to = of.getTo();
        for (int i = 0; i < to.length; ++i) {
            cmd = cmd + "," + to[i];
        }
        SOCResourceSet give = of.getGiveSet();
        for (int i = 1; i <= 5; ++i) {
            cmd = cmd + "," + give.getAmount(i);
        }
        SOCResourceSet get = of.getGetSet();
        for (int i = 1; i <= 5; ++i) {
            cmd = cmd + "," + get.getAmount(i);
        }
        return cmd;
    }

    public static SOCMakeOffer parseDataStr(String s) {
        boolean[] to;
        int from;
        String ga;
        SOCResourceSet give = new SOCResourceSet();
        SOCResourceSet get = new SOCResourceSet();
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            int i;
            ga = st.nextToken();
            from = Integer.parseInt(st.nextToken());
            int numPlayerTokens = st.countTokens() - 10;
            to = new boolean[numPlayerTokens];
            for (i = 0; i < numPlayerTokens; ++i) {
                to[i] = Boolean.valueOf(st.nextToken());
            }
            for (i = 1; i <= 5; ++i) {
                give.setAmount(Integer.parseInt(st.nextToken()), i);
            }
            for (i = 1; i <= 5; ++i) {
                get.setAmount(Integer.parseInt(st.nextToken()), i);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCMakeOffer(ga, new SOCTradeOffer(ga, from, to, give, get));
    }

    public static String stripAttribNames(String message) {
        int offerFieldIdx = message.indexOf("|offer=game=");
        if (offerFieldIdx != -1) {
            int nextIdx = message.indexOf(124, offerFieldIdx + 11);
            if (nextIdx == -1) {
                return null;
            }
            message = message.substring(0, offerFieldIdx) + message.substring(nextIdx);
        }
        message = message.replace("give=", "");
        message = message.replace("get=", "");
        message = message.replaceAll("\\|unknown=0", "");
        return SOCMessage.stripAttribNames(message);
    }

    @Override
    public String toString() {
        return "SOCMakeOffer:game=" + this.game + '|' + this.offer.toString(true);
    }
}

