/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCAdminPing;
import soc.message.SOCAdminReset;
import soc.message.SOCAuthRequest;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBoardLayout2;
import soc.message.SOCBotGameDataCheck;
import soc.message.SOCBotJoinGameRequest;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyDevCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannelMembers;
import soc.message.SOCChannelTextMsg;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCCreateAccount;
import soc.message.SOCDebugFreePlace;
import soc.message.SOCDeclinePlayerRequest;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCardAction;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiceResultResources;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCEndTurn;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameElements;
import soc.message.SOCGameMembers;
import soc.message.SOCGameOptionGetDefaults;
import soc.message.SOCGameOptionGetInfos;
import soc.message.SOCGameOptionInfo;
import soc.message.SOCGameServerText;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCGamesWithOptions;
import soc.message.SOCImARobot;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCJoinChannel;
import soc.message.SOCJoinChannelAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCLargestArmy;
import soc.message.SOCLastSettlement;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveChannel;
import soc.message.SOCLeaveGame;
import soc.message.SOCLocalizedStrings;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessageMulti;
import soc.message.SOCMovePiece;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCNewGameWithOptions;
import soc.message.SOCNewGameWithOptionsRequest;
import soc.message.SOCPickResourceType;
import soc.message.SOCPickResources;
import soc.message.SOCPieceValue;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPlayerElements;
import soc.message.SOCPlayerStats;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCRemovePiece;
import soc.message.SOCResetBoardAuth;
import soc.message.SOCResetBoardReject;
import soc.message.SOCResetBoardRequest;
import soc.message.SOCResetBoardVote;
import soc.message.SOCResetBoardVoteRequest;
import soc.message.SOCResourceCount;
import soc.message.SOCRevealFogHex;
import soc.message.SOCRobberyResult;
import soc.message.SOCRobotDismiss;
import soc.message.SOCRollDice;
import soc.message.SOCRollDicePrompt;
import soc.message.SOCRollDiceRequest;
import soc.message.SOCSVPTextMessage;
import soc.message.SOCScenarioInfo;
import soc.message.SOCServerPing;
import soc.message.SOCSetLastAction;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetShipRouteClosed;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSetTurn;
import soc.message.SOCSimpleAction;
import soc.message.SOCSimpleRequest;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTimingPing;
import soc.message.SOCTurn;
import soc.message.SOCUndoNotAllowedReasonText;
import soc.message.SOCUndoPutPiece;
import soc.message.SOCUpdateRobotParams;
import soc.message.SOCVersion;

public abstract class SOCMessage
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2000L;
    public static final String EMPTYSTR = "\t";
    public static final int AUTHREQUEST = 999;
    public static final int NULLMESSAGE = 1000;
    public static final int NEWCHANNEL = 1001;
    public static final int CHANNELMEMBERS = 1002;
    public static final int CHANNELS = 1003;
    public static final int JOINCHANNEL = 1004;
    public static final int CHANNELTEXTMSG = 1005;
    public static final int LEAVECHANNEL = 1006;
    public static final int DELETECHANNEL = 1007;
    public static final int LEAVEALL = 1008;
    public static final int PUTPIECE = 1009;
    public static final int GAMETEXTMSG = 1010;
    public static final int LEAVEGAME = 1011;
    public static final int SITDOWN = 1012;
    public static final int JOINGAME = 1013;
    public static final int BOARDLAYOUT = 1014;
    public static final int DELETEGAME = 1015;
    public static final int NEWGAME = 1016;
    public static final int GAMEMEMBERS = 1017;
    public static final int STARTGAME = 1018;
    public static final int GAMES = 1019;
    public static final int JOINCHANNELAUTH = 1020;
    public static final int JOINGAMEAUTH = 1021;
    public static final int IMAROBOT = 1022;
    public static final int BOTJOINGAMEREQUEST = 1023;
    public static final int PLAYERELEMENT = 1024;
    public static final int GAMESTATE = 1025;
    public static final int TURN = 1026;
    public static final int DICERESULT = 1028;
    public static final int DISCARDREQUEST = 1029;
    public static final int ROLLDICEREQUEST = 1030;
    public static final int ROLLDICE = 1031;
    public static final int ENDTURN = 1032;
    public static final int DISCARD = 1033;
    public static final int MOVEROBBER = 1034;
    public static final int CHOOSEPLAYER = 1035;
    public static final int CHOOSEPLAYERREQUEST = 1036;
    public static final int REJECTOFFER = 1037;
    public static final int CLEAROFFER = 1038;
    public static final int ACCEPTOFFER = 1039;
    public static final int BANKTRADE = 1040;
    public static final int MAKEOFFER = 1041;
    public static final int CLEARTRADEMSG = 1042;
    public static final int BUILDREQUEST = 1043;
    public static final int CANCELBUILDREQUEST = 1044;
    public static final int BUYDEVCARDREQUEST = 1045;
    public static final int DEVCARDACTION = 1046;
    public static final int DEVCARDCOUNT = 1047;
    public static final int SETPLAYEDDEVCARD = 1048;
    public static final int PLAYDEVCARDREQUEST = 1049;
    public static final int PICKRESOURCES = 1052;
    public static final int PICKRESOURCETYPE = 1053;
    public static final int FIRSTPLAYER = 1054;
    public static final int SETTURN = 1055;
    public static final int ROBOTDISMISS = 1056;
    public static final int POTENTIALSETTLEMENTS = 1057;
    public static final int CHANGEFACE = 1058;
    public static final int REJECTCONNECTION = 1059;
    public static final int LASTSETTLEMENT = 1060;
    public static final int GAMESTATS = 1061;
    public static final int BCASTTEXTMSG = 1062;
    public static final int RESOURCECOUNT = 1063;
    public static final int ADMINPING = 1064;
    public static final int ADMINRESET = 1065;
    public static final int LONGESTROAD = 1066;
    public static final int LARGESTARMY = 1067;
    public static final int SETSEATLOCK = 1068;
    public static final int STATUSMESSAGE = 1069;
    public static final int CREATEACCOUNT = 1070;
    public static final int UPDATEROBOTPARAMS = 1071;
    public static final int ROLLDICEPROMPT = 1072;
    public static final int RESETBOARDREQUEST = 1073;
    public static final int RESETBOARDAUTH = 1074;
    public static final int RESETBOARDVOTEREQUEST = 1075;
    public static final int RESETBOARDVOTE = 1076;
    public static final int RESETBOARDREJECT = 1077;
    public static final int NEWGAMEWITHOPTIONSREQUEST = 1078;
    public static final int NEWGAMEWITHOPTIONS = 1079;
    public static final int GAMEOPTIONGETDEFAULTS = 1080;
    public static final int GAMEOPTIONGETINFOS = 1081;
    public static final int GAMEOPTIONINFO = 1082;
    public static final int GAMESWITHOPTIONS = 1083;
    public static final int BOARDLAYOUT2 = 1084;
    public static final int PLAYERSTATS = 1085;
    public static final int PLAYERELEMENTS = 1086;
    public static final int DEBUGFREEPLACE = 1087;
    public static final int TIMINGPING = 1088;
    public static final int SIMPLEREQUEST = 1089;
    public static final int SIMPLEACTION = 1090;
    public static final int GAMESERVERTEXT = 1091;
    public static final int DICERESULTRESOURCES = 1092;
    public static final int MOVEPIECE = 1093;
    public static final int REMOVEPIECE = 1094;
    public static final int PIECEVALUE = 1095;
    public static final int GAMEELEMENTS = 1096;
    public static final int SVPTEXTMSG = 1097;
    public static final int INVENTORYITEMACTION = 1098;
    public static final int SETSPECIALITEM = 1099;
    public static final int LOCALIZEDSTRINGS = 1100;
    public static final int SCENARIOINFO = 1101;
    public static final int ROBBERYRESULT = 1102;
    public static final int BOTGAMEDATACHECK = 1103;
    public static final int DECLINEPLAYERREQUEST = 1104;
    public static final int UNDOPUTPIECE = 1105;
    public static final int SETLASTACTION = 1106;
    public static final int UNDONOTALLOWEDREASONTEXT = 1107;
    public static final int VERSION = 9998;
    public static final int SERVERPING = 9999;
    public static final int REVEALFOGHEX = 10001;
    public static final int SETSHIPROUTECLOSED = 10002;
    public static final String sep = "|";
    public static final String sepRE = "\\|";
    public static final String sep2 = ",";
    public static final char sep_char = '|';
    public static final char sep2_char = ',';
    public static final String GAME_NONE = "\u0016";
    protected int messageType;
    public static final Map<String, String> MESSAGE_RENAME_MAP = new HashMap<String, String>();

    public int getType() {
        return this.messageType;
    }

    public int getMinimumVersion() {
        return 1000;
    }

    public int getMaximumVersion() {
        return Integer.MAX_VALUE;
    }

    public abstract String toCmd();

    public abstract String toString();

    public static final boolean isSingleLineAndSafe(String s) {
        return SOCMessage.isSingleLineAndSafe(s, false);
    }

    public static final boolean isSingleLineAndSafe(String s, boolean allowSepChars) {
        if (s == null) {
            return false;
        }
        if (!(allowSepChars || -1 == s.indexOf(124) && -1 == s.indexOf(44))) {
            return false;
        }
        int i = s.length();
        if (i == 0) {
            return false;
        }
        --i;
        while (i >= 0) {
            char c = s.charAt(i);
            if (Character.isISOControl(c) || Character.isSpaceChar(c) && Character.getType(c) != 12) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static SOCMessage toMsg(String s) {
        try {
            String data;
            StringTokenizer st = new StringTokenizer(s, sep);
            int msgId = Integer.parseInt(st.nextToken());
            ArrayList<String> multiData = null;
            try {
                data = st.nextToken();
                if (st.hasMoreTokens()) {
                    int n = st.countTokens();
                    multiData = new ArrayList<String>(n + 1);
                    multiData.add(data);
                    while (st.hasMoreTokens()) {
                        try {
                            multiData.add(st.nextToken());
                        }
                        catch (NoSuchElementException e) {
                            multiData.add(null);
                        }
                    }
                }
            }
            catch (NoSuchElementException e) {
                data = "";
            }
            switch (msgId) {
                case 999: {
                    return SOCAuthRequest.parseDataStr(data);
                }
                case 1000: {
                    return null;
                }
                case 1001: {
                    return SOCNewChannel.parseDataStr(data);
                }
                case 1002: {
                    return SOCChannelMembers.parseDataStr(data);
                }
                case 1003: {
                    return SOCChannels.parseDataStr(data);
                }
                case 1004: {
                    return SOCJoinChannel.parseDataStr(data);
                }
                case 1005: {
                    return SOCChannelTextMsg.parseDataStr(data);
                }
                case 1006: {
                    return SOCLeaveChannel.parseDataStr(data);
                }
                case 1007: {
                    return SOCDeleteChannel.parseDataStr(data);
                }
                case 1008: {
                    return SOCLeaveAll.parseDataStr(data);
                }
                case 1009: {
                    return SOCPutPiece.parseDataStr(data);
                }
                case 1010: {
                    return SOCGameTextMsg.parseDataStr(data);
                }
                case 1011: {
                    return SOCLeaveGame.parseDataStr(data);
                }
                case 1012: {
                    return SOCSitDown.parseDataStr(data);
                }
                case 1013: {
                    return SOCJoinGame.parseDataStr(data);
                }
                case 1014: {
                    return SOCBoardLayout.parseDataStr(data);
                }
                case 1019: {
                    return SOCGames.parseDataStr(data);
                }
                case 1015: {
                    return SOCDeleteGame.parseDataStr(data);
                }
                case 1016: {
                    return SOCNewGame.parseDataStr(data);
                }
                case 1017: {
                    return SOCGameMembers.parseDataStr(data);
                }
                case 1018: {
                    return SOCStartGame.parseDataStr(data);
                }
                case 1020: {
                    return SOCJoinChannelAuth.parseDataStr(data);
                }
                case 1021: {
                    return SOCJoinGameAuth.parseDataStr(data);
                }
                case 1022: {
                    return SOCImARobot.parseDataStr(data);
                }
                case 1023: {
                    return SOCBotJoinGameRequest.parseDataStr(data);
                }
                case 1024: {
                    return SOCPlayerElement.parseDataStr(data);
                }
                case 1025: {
                    return SOCGameState.parseDataStr(data);
                }
                case 1026: {
                    return SOCTurn.parseDataStr(data);
                }
                case 1028: {
                    return SOCDiceResult.parseDataStr(data);
                }
                case 1029: {
                    return SOCDiscardRequest.parseDataStr(data);
                }
                case 1030: {
                    return SOCRollDiceRequest.parseDataStr(data);
                }
                case 1031: {
                    return SOCRollDice.parseDataStr(data);
                }
                case 1032: {
                    return SOCEndTurn.parseDataStr(data);
                }
                case 1033: {
                    return SOCDiscard.parseDataStr(data);
                }
                case 1034: {
                    return SOCMoveRobber.parseDataStr(data);
                }
                case 1035: {
                    return SOCChoosePlayer.parseDataStr(data);
                }
                case 1036: {
                    return SOCChoosePlayerRequest.parseDataStr(data);
                }
                case 1037: {
                    return SOCRejectOffer.parseDataStr(data);
                }
                case 1038: {
                    return SOCClearOffer.parseDataStr(data);
                }
                case 1039: {
                    return SOCAcceptOffer.parseDataStr(data);
                }
                case 1040: {
                    return SOCBankTrade.parseDataStr(data);
                }
                case 1041: {
                    return SOCMakeOffer.parseDataStr(data);
                }
                case 1042: {
                    return SOCClearTradeMsg.parseDataStr(data);
                }
                case 1043: {
                    return SOCBuildRequest.parseDataStr(data);
                }
                case 1044: {
                    return SOCCancelBuildRequest.parseDataStr(data);
                }
                case 1045: {
                    return SOCBuyDevCardRequest.parseDataStr(data);
                }
                case 1046: {
                    return SOCDevCardAction.parseDataStr(data);
                }
                case 1047: {
                    return SOCDevCardCount.parseDataStr(data);
                }
                case 1048: {
                    return SOCSetPlayedDevCard.parseDataStr(data);
                }
                case 1049: {
                    return SOCPlayDevCardRequest.parseDataStr(data);
                }
                case 1052: {
                    return SOCPickResources.parseDataStr(data);
                }
                case 1053: {
                    return SOCPickResourceType.parseDataStr(data);
                }
                case 1054: {
                    return SOCFirstPlayer.parseDataStr(data);
                }
                case 1055: {
                    return SOCSetTurn.parseDataStr(data);
                }
                case 1056: {
                    return SOCRobotDismiss.parseDataStr(data);
                }
                case 1057: {
                    return SOCPotentialSettlements.parseDataStr(data);
                }
                case 1058: {
                    return SOCChangeFace.parseDataStr(data);
                }
                case 1059: {
                    return SOCRejectConnection.parseDataStr(data);
                }
                case 1060: {
                    return SOCLastSettlement.parseDataStr(data);
                }
                case 1061: {
                    return SOCGameStats.parseDataStr(data);
                }
                case 1062: {
                    return SOCBCastTextMsg.parseDataStr(data);
                }
                case 1063: {
                    return SOCResourceCount.parseDataStr(data);
                }
                case 1064: {
                    return SOCAdminPing.parseDataStr(data);
                }
                case 1065: {
                    return SOCAdminReset.parseDataStr(data);
                }
                case 1066: {
                    return SOCLongestRoad.parseDataStr(data);
                }
                case 1067: {
                    return SOCLargestArmy.parseDataStr(data);
                }
                case 1068: {
                    return SOCSetSeatLock.parseDataStr(data);
                }
                case 1069: {
                    return SOCStatusMessage.parseDataStr(data);
                }
                case 1070: {
                    return SOCCreateAccount.parseDataStr(data);
                }
                case 1071: {
                    return SOCUpdateRobotParams.parseDataStr(data);
                }
                case 9999: {
                    return SOCServerPing.parseDataStr(data);
                }
                case 1072: {
                    return SOCRollDicePrompt.parseDataStr(data);
                }
                case 1073: {
                    return SOCResetBoardRequest.parseDataStr(data);
                }
                case 1074: {
                    return SOCResetBoardAuth.parseDataStr(data);
                }
                case 1075: {
                    return SOCResetBoardVoteRequest.parseDataStr(data);
                }
                case 1076: {
                    return SOCResetBoardVote.parseDataStr(data);
                }
                case 1077: {
                    return SOCResetBoardReject.parseDataStr(data);
                }
                case 9998: {
                    return SOCVersion.parseDataStr(data);
                }
                case 1079: {
                    return SOCNewGameWithOptions.parseDataStr(data);
                }
                case 1078: {
                    return SOCNewGameWithOptionsRequest.parseDataStr(data);
                }
                case 1080: {
                    return SOCGameOptionGetDefaults.parseDataStr(data);
                }
                case 1081: {
                    return SOCGameOptionGetInfos.parseDataStr(data);
                }
                case 1082: {
                    return SOCGameOptionInfo.parseDataStr(multiData);
                }
                case 1083: {
                    return SOCGamesWithOptions.parseDataStr(multiData);
                }
                case 1084: {
                    return SOCBoardLayout2.parseDataStr(data);
                }
                case 1085: {
                    return SOCPlayerStats.parseDataStr(multiData);
                }
                case 1086: {
                    return SOCPlayerElements.parseDataStr(multiData);
                }
                case 1087: {
                    return SOCDebugFreePlace.parseDataStr(data);
                }
                case 1088: {
                    return SOCTimingPing.parseDataStr(data);
                }
                case 1089: {
                    return SOCSimpleRequest.parseDataStr(data);
                }
                case 1090: {
                    return SOCSimpleAction.parseDataStr(data);
                }
                case 1091: {
                    return SOCGameServerText.parseDataStr(data);
                }
                case 1092: {
                    return SOCDiceResultResources.parseDataStr(multiData);
                }
                case 1093: {
                    return SOCMovePiece.parseDataStr(data);
                }
                case 1094: {
                    return SOCRemovePiece.parseDataStr(data);
                }
                case 1095: {
                    return SOCPieceValue.parseDataStr(data);
                }
                case 1096: {
                    return SOCGameElements.parseDataStr(multiData);
                }
                case 1097: {
                    return SOCSVPTextMessage.parseDataStr(data);
                }
                case 1098: {
                    return SOCInventoryItemAction.parseDataStr(data);
                }
                case 1099: {
                    return SOCSetSpecialItem.parseDataStr(data);
                }
                case 1100: {
                    return SOCLocalizedStrings.parseDataStr(multiData);
                }
                case 1101: {
                    return SOCScenarioInfo.parseDataStr(multiData, data);
                }
                case 1102: {
                    return SOCRobberyResult.parseDataStr(data);
                }
                case 1103: {
                    return SOCBotGameDataCheck.parseDataStr(multiData);
                }
                case 1104: {
                    return SOCDeclinePlayerRequest.parseDataStr(data);
                }
                case 1105: {
                    return SOCUndoPutPiece.parseDataStr(data);
                }
                case 1106: {
                    return SOCSetLastAction.parseDataStr(data);
                }
                case 1107: {
                    return SOCUndoNotAllowedReasonText.parseDataStr(data);
                }
                case 10001: {
                    return SOCRevealFogHex.parseDataStr(data);
                }
                case 10002: {
                    return SOCSetShipRouteClosed.parseDataStr(multiData);
                }
            }
            System.err.println("Unhandled message type in SOCMessage.toMsg: " + msgId);
            return null;
        }
        catch (Exception e) {
            System.err.println("toMsg ERROR - " + e);
            e.printStackTrace();
            return null;
        }
    }

    public static SOCMessage parseMsgStr(String messageStr) throws ParseException, InputMismatchException {
        if (messageStr == null) {
            throw new ParseException("null messageStr", 0);
        }
        int colonIdx = messageStr.indexOf(58);
        if (colonIdx < 1) {
            throw new ParseException("Missing \"SomeMsgClassName:\" prefix", 0);
        }
        String className = null;
        String currentCall = null;
        try {
            Method m;
            Class<?> c;
            className = messageStr.substring(0, colonIdx);
            String msgBody = messageStr.substring(colonIdx + 1);
            String origClassName = className;
            String renamedClassName = MESSAGE_RENAME_MAP.get(className);
            if (renamedClassName != null) {
                className = renamedClassName;
            }
            if (SOCMessageMulti.class.isAssignableFrom(c = Class.forName("soc.message." + className))) {
                try {
                    Method m2 = c.getMethod("stripAttribsToList", String.class);
                    if (!Modifier.isStatic(m2.getModifiers())) {
                        throw new ParseException(className + ".stripAttribsToList must be static", 0);
                    }
                    currentCall = m2.getDeclaringClass().getName() + ".stripAttribsToList";
                    List treatedAttribs = (List)m2.invoke(null, msgBody);
                    if (treatedAttribs == null) {
                        throw new InputMismatchException("Unparsable message: stripAttribsToList rets null: " + messageStr);
                    }
                    try {
                        m2 = c.getMethod("parseDataStr", List.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ParseException(className + ".parseDataStr(List) not found", 0);
                    }
                    if (!Modifier.isStatic(m2.getModifiers())) {
                        throw new ParseException(className + ".parseDataStr(List) must be static", 0);
                    }
                    currentCall = m2.getDeclaringClass().getName() + ".parseDataStr";
                    Object o = m2.invoke(null, treatedAttribs);
                    if (o == null) {
                        throw new InputMismatchException("Unparsable message: parseDataStr(List) rets null: " + messageStr);
                    }
                    return (SOCMessage)o;
                }
                catch (NoSuchMethodException treatedAttribs) {
                    // empty catch block
                }
            }
            String treatedAttribs = null;
            try {
                m = c.getMethod("stripAttribNames", String.class, String.class);
                currentCall = m.getDeclaringClass().getName() + ".stripAttribNames(String,String)";
                if (!Modifier.isStatic(m.getModifiers())) {
                    throw new ParseException(currentCall + " must be static", 0);
                }
                if (!m.getReturnType().equals(String.class)) {
                    throw new ParseException(currentCall + " must return String", 0);
                }
                treatedAttribs = (String)m.invoke(null, origClassName != null ? origClassName : className, msgBody);
                if (treatedAttribs == null) {
                    throw new InputMismatchException("Unparsable message: stripAttribNames(String,String) rets null: " + messageStr);
                }
            }
            catch (NoSuchMethodException o) {
                // empty catch block
            }
            if (treatedAttribs == null) {
                m = c.getMethod("stripAttribNames", String.class);
                currentCall = m.getDeclaringClass().getName() + ".stripAttribNames(String)";
                if (!Modifier.isStatic(m.getModifiers())) {
                    throw new ParseException(currentCall + " must be static", 0);
                }
                treatedAttribs = (String)m.invoke(null, msgBody);
            }
            if (treatedAttribs == null) {
                throw new InputMismatchException("Unparsable message: stripAttribNames rets null: " + messageStr);
            }
            m = c.getMethod("parseDataStr", String.class);
            currentCall = m.getDeclaringClass().getName() + ".parseDataStr";
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new ParseException(currentCall + " must be static", 0);
            }
            Object o = m.invoke(null, treatedAttribs);
            if (o == null) {
                throw new InputMismatchException("Unparsable message: parseDataStr rets null: " + messageStr);
            }
            return (SOCMessage)o;
        }
        catch (ClassNotFoundException ex) {
            throw new ParseException("Class not found" + (className != null ? ": " + className : "") + ": " + messageStr, 0);
        }
        catch (InvocationTargetException ex) {
            throw new ParseException("Exception from " + currentCall + ": " + ex.getCause(), 0);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | NoSuchMethodException | SecurityException ex) {
            throw new ParseException("Reflection error calling " + currentCall + ": " + ex, 0);
        }
        catch (InputMismatchException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ParseException("Exception from " + currentCall + ": " + ex, 0);
        }
    }

    public static String stripAttribNames(String messageStrParams) {
        StringBuilder sb = new StringBuilder();
        for (String s : messageStrParams.split(sepRE)) {
            int eqIdx = s.indexOf(61);
            sb.append(s.substring(eqIdx + 1)).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static List<String> stripAttribsToList(String messageStrParams) {
        String[] params = messageStrParams.split(sepRE);
        for (int i = 0; i < params.length; ++i) {
            int eqIdx = params[i].indexOf(61);
            if (eqIdx <= 0) continue;
            params[i] = params[i].substring(eqIdx + 1);
        }
        return Arrays.asList(params);
    }

    static {
        for (String[] fromTo : new String[][]{{"SOCBuyCardRequest", "SOCBuyDevCardRequest"}, {"SOCDevCard", "SOCDevCardAction"}, {"SOCDiscoveryPick", "SOCPickResources"}, {"SOCJoin", "SOCJoinChannel"}, {"SOCJoinAuth", "SOCJoinChannelAuth"}, {"SOCJoinGameRequest", "SOCBotJoinGameRequest"}, {"SOCLeave", "SOCLeaveChannel"}, {"SOCMembers", "SOCChannelMembers"}, {"SOCMonopolyPick", "SOCPickResourceType"}, {"SOCTextMsg", "SOCChannelTextMsg"}}) {
            MESSAGE_RENAME_MAP.put(fromTo[0], fromTo[1]);
        }
    }
}

