/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageTemplate4i;

public class SOCMovePiece
extends SOCMessageTemplate4i {
    private static final long serialVersionUID = 2000L;

    public SOCMovePiece(String ga, int pn, int ptype, int fromCoord, int toCoord) throws IllegalArgumentException {
        super(1093, ga, pn, ptype, fromCoord, toCoord);
        if (ptype < 0) {
            throw new IllegalArgumentException("pt < 0: " + ptype);
        }
        if (fromCoord < 0) {
            throw new IllegalArgumentException("fromCoord < 0");
        }
        if (toCoord < 0) {
            throw new IllegalArgumentException("toCoord < 0");
        }
    }

    public int getPlayerNumber() {
        return this.p1;
    }

    public int getPieceType() {
        return this.p2;
    }

    public int getFromCoord() {
        return this.p3;
    }

    public int getToCoord() {
        return this.p4;
    }

    public static String toCmd(String ga, int pn, int ptype, int fromCoord, int toCoord) throws IllegalArgumentException {
        if (ptype < 0) {
            throw new IllegalArgumentException("pt < 0: " + ptype);
        }
        if (fromCoord < 0) {
            throw new IllegalArgumentException("fromCoord < 0");
        }
        if (toCoord < 0) {
            throw new IllegalArgumentException("toCoord < 0");
        }
        return "1093|" + ga + "," + pn + "," + ptype + "," + fromCoord + "," + toCoord;
    }

    public static SOCMovePiece parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String ga = st.nextToken();
            int pn = Integer.parseInt(st.nextToken());
            int pc = Integer.parseInt(st.nextToken());
            int fc = Integer.parseInt(st.nextToken());
            int tc = Integer.parseInt(st.nextToken());
            return new SOCMovePiece(ga, pn, pc, fc, tc);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getMinimumVersion() {
        return 2000;
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            ret.append(pieces[i]).append(',');
        }
        ret.append(Integer.parseInt(pieces[3], 16)).append(',');
        ret.append(Integer.parseInt(pieces[4], 16));
        return ret.toString();
    }

    @Override
    public String toString() {
        return "SOCMovePiece:game=" + this.game + "|pn=" + this.p1 + "|pieceType=" + this.p2 + "|fromCoord=" + Integer.toHexString(this.p3) + "|toCoord=" + Integer.toHexString(this.p4);
    }
}

