/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCMoveRobber
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int playerNumber;
    private int coordinates;

    public SOCMoveRobber(String na, int pn, int co) {
        this.messageType = 1034;
        this.game = na;
        this.playerNumber = pn;
        this.coordinates = co;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    @Override
    public String toCmd() {
        return SOCMoveRobber.toCmd(this.game, this.playerNumber, this.coordinates);
    }

    public static String toCmd(String na, int pn, int co) {
        return "1034|" + na + "," + pn + "," + co;
    }

    public static SOCMoveRobber parseDataStr(String s) {
        int co;
        int pn;
        String na;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            na = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            co = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCMoveRobber(na, pn, co);
    }

    public static String stripAttribNames(String message) {
        String s = SOCMessage.stripAttribNames(message);
        if (s == null) {
            return null;
        }
        int i = s.lastIndexOf(44);
        StringBuilder ret = new StringBuilder();
        ret.append(s.substring(0, i + 1));
        String robberHex = s.substring(i + 1);
        ret.append(Integer.parseInt(robberHex, 16));
        return ret.toString();
    }

    @Override
    public String toString() {
        String s = "SOCMoveRobber:game=" + this.game + "|playerNumber=" + this.playerNumber + "|coord=" + (this.coordinates >= 0 ? Integer.toHexString(this.coordinates) : "-" + Integer.toHexString(-this.coordinates));
        return s;
    }
}

