/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Map;
import java.util.StringTokenizer;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.message.SOCMessageFromUnauthClient;
import soc.message.SOCMessageTemplateJoinGame;

public class SOCNewGameWithOptionsRequest
extends SOCMessageTemplateJoinGame
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2000L;
    private String optsStr;
    private Map<String, SOCGameOption> opts;

    public SOCNewGameWithOptionsRequest(String nn, String pw, String hn, String ga, String optstr) {
        super(nn, pw, hn, ga);
        this.messageType = 1078;
        this.optsStr = optstr;
        this.opts = null;
    }

    public Map<String, SOCGameOption> getOptions(SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        if (this.opts == null) {
            this.opts = SOCGameOption.parseOptionsToMap(this.optsStr, knownOpts);
        }
        return this.opts;
    }

    @Override
    public String toCmd() {
        return SOCNewGameWithOptionsRequest.toCmd(this.nickname, this.password, this.host, this.game, this.optsStr);
    }

    public static String toCmd(String nn, String pw, String hn, String ga, String optstr) {
        if (pw.length() == 0) {
            pw = "\t";
        }
        return "1078|" + nn + "," + pw + "," + hn + "," + ga + "," + optstr;
    }

    public static String toCmd(String nn, String pw, String hn, String ga, Map<String, SOCGameOption> opts) {
        return SOCNewGameWithOptionsRequest.toCmd(nn, pw, hn, ga, SOCGameOption.packOptionsToString(opts, false, false));
    }

    public static SOCNewGameWithOptionsRequest parseDataStr(String s) {
        String optstr;
        String ga;
        String hn;
        String pw;
        String nn;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            nn = st.nextToken();
            pw = st.nextToken();
            hn = st.nextToken();
            ga = st.nextToken();
            optstr = st.nextToken("|");
            if (pw.equals("\t")) {
                pw = "";
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCNewGameWithOptionsRequest(nn, pw, hn, ga, optstr);
    }

    @Override
    public int getMinimumVersion() {
        return 1107;
    }

    @Override
    public String toString() {
        return super.toString("SOCNewGameWithOptionsRequest", "opts=" + this.optsStr);
    }
}

