/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCPickResources
extends SOCMessage
implements SOCMessageForGame {
    public static final int VERSION_FOR_SERVER_ANNOUNCE = 2500;
    public static final int REASON_GENERIC = 1;
    public static final int REASON_DISCOVERY = 2;
    public static final int REASON_GOLD_HEX = 3;
    private static final long serialVersionUID = 2500L;
    private String game;
    private SOCResourceSet resources;
    private int playerNumber;
    private int reasonCode;

    public SOCPickResources(String ga, int cl, int or, int sh, int wh, int wo) {
        this(ga, new SOCResourceSet(cl, or, sh, wh, wo, 0));
    }

    public SOCPickResources(String ga, SOCResourceSet rs) {
        this(ga, rs, 0, 0);
    }

    public SOCPickResources(String ga, SOCResourceSet rs, int pn, int rc) {
        this.messageType = 1052;
        this.game = ga;
        this.resources = rs;
        this.playerNumber = pn;
        this.reasonCode = rc;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCResourceSet getResources() {
        return this.resources;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public String toCmd() {
        StringBuilder cmd = new StringBuilder("1052|" + this.game);
        for (int i = 1; i <= 5; ++i) {
            cmd.append(',').append(this.resources.getAmount(i));
        }
        if (this.playerNumber != 0 || this.reasonCode != 0) {
            cmd.append(',').append(this.playerNumber).append(',').append(this.reasonCode);
        }
        return cmd.toString();
    }

    public static SOCPickResources parseDataStr(String s) {
        int wo;
        int wh;
        int sh;
        int or;
        int cl;
        String ga;
        int pn = 0;
        int reasonCode = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            cl = Integer.parseInt(st.nextToken());
            or = Integer.parseInt(st.nextToken());
            sh = Integer.parseInt(st.nextToken());
            wh = Integer.parseInt(st.nextToken());
            wo = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                pn = Integer.parseInt(st.nextToken());
                reasonCode = Integer.parseInt(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCPickResources(ga, new SOCResourceSet(cl, or, sh, wh, wo, 0), pn, reasonCode);
    }

    public static String stripAttribNames(String message) {
        message = message.replace("resources=", "").replace("|unknown=0", "");
        return SOCMessage.stripAttribNames(message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCPickResources:game=" + this.game + "|resources=" + this.resources);
        if (this.playerNumber != 0 || this.reasonCode != 0) {
            sb.append("|pn=").append(this.playerNumber).append("|reason=").append(this.reasonCode);
        }
        return sb.toString();
    }
}

